/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.front;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAdListener;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.InterstitialAd;
import com.tnkfactory.ad.TnkAdListener;
import com.tnkfactory.ad.TnkSession;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.front.OnFrontAdListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

public class TedAdFront {
    private static OnFrontAdListener onFrontAdListener;
    private static String facebookKey;
    private static String admobKey;
    private static WeakReference<Activity> activityRef;
    private static ArrayList<Integer> adPriorityList;

    public static void showFacebookFrontAd(Activity activity, String facebookKey, OnFrontAdListener onFrontAdListener) {
        TedAdFront.showFrontAD(activity, facebookKey, null, 1, onFrontAdListener);
    }

    public static void showAdmobFrontAd(Activity activity, String admobKey, OnFrontAdListener onFrontAdListener) {
        TedAdFront.showFrontAD(activity, null, admobKey, 2, onFrontAdListener);
    }

    public static void showFrontAD(Activity activity, String facebookKey, String admobKey, int adPriority, OnFrontAdListener onFrontAdListener) {
        Integer[] tempAdPriorityList = new Integer[]{adPriority, adPriority == 1 ? Integer.valueOf(2) : Integer.valueOf(1)};
        TedAdFront.showFrontAD(activity, facebookKey, admobKey, tempAdPriorityList, onFrontAdListener);
    }

    public static void showFrontAD(Activity activity, String facebookKey, String admobKey, Integer[] tempAdPriorityList, OnFrontAdListener onFrontAdListener) {
        if (tempAdPriorityList == null || tempAdPriorityList.length == 0) {
            throw new RuntimeException("You have to select priority type ADMOB/FACEBOOK/TNK");
        }
        adPriorityList = new ArrayList<Integer>(Arrays.asList(tempAdPriorityList));
        try {
            activityRef = new WeakReference<Activity>(activity);
            TedAdFront.facebookKey = facebookKey;
            TedAdFront.admobKey = admobKey;
            TedAdFront.onFrontAdListener = onFrontAdListener;
            TedAdFront.selectAd();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (onFrontAdListener != null) {
                onFrontAdListener.onError(e.toString());
            }
            TedAdFront.finishAd();
        }
    }

    private static void selectAd() {
        int adPriority = adPriorityList.remove(0);
        switch (adPriority) {
            case 1: {
                TedAdFront.showFacebookFrontAd();
                break;
            }
            case 2: {
                TedAdFront.showAdmobFrontAd();
                break;
            }
            case 3: {
                TedAdFront.showTnkFrontAd();
                break;
            }
            default: {
                onFrontAdListener.onError("You have to select priority type ADMOB or FACEBOOK");
                TedAdFront.finishAd();
            }
        }
    }

    private static void showFacebookFrontAd() {
        if (TedAdHelper.isSkipFacebookAd((Context)activityRef.get())) {
            Log.e((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Error: Facebook app not installed");
            TedAdFront.onError("Facebook app not installed");
            return;
        }
        final com.facebook.ads.InterstitialAd facebookFrontAD = new com.facebook.ads.InterstitialAd((Context)activityRef.get(), facebookKey);
        if (onFrontAdListener != null) {
            onFrontAdListener.onFacebookAdCreated(facebookFrontAD);
        }
        facebookFrontAD.setAdListener(new InterstitialAdListener(){

            public void onInterstitialDisplayed(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Displayed");
            }

            public void onInterstitialDismissed(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Dismissed");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onDismissed(1);
                    TedAdFront.finishAd();
                }
            }

            public void onError(Ad ad, AdError adError) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK FRONT AD]Error: " + adError.getErrorMessage()));
                TedAdFront.onError(adError.getErrorMessage());
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Loaded");
                try {
                    if (facebookFrontAD != null) {
                        facebookFrontAD.show();
                    }
                }
                catch (Exception e) {
                    TedAdFront.onError(e.getMessage());
                    return;
                }
                if (onFrontAdListener != null) {
                    onFrontAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Clicked");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onAdClicked(1);
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        facebookFrontAD.loadAd();
    }

    private static void showAdmobFrontAd() {
        final InterstitialAd admobFrontAD = new InterstitialAd((Context)activityRef.get());
        admobFrontAD.setAdListener(new AdListener(){

            public void onAdClosed() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Dismissed");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onDismissed(2);
                }
            }

            public void onAdFailedToLoad(int errorCode) {
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                Log.e((String)"TedAdHelper", (String)("[ADMOB FRONT AD]Error: " + errorMessage));
                TedAdFront.onError(errorMessage);
            }

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Loaded");
                admobFrontAD.show();
                if (onFrontAdListener != null) {
                    onFrontAdListener.onLoaded(2);
                }
            }

            public void onAdLeftApplication() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Clicked");
                super.onAdLeftApplication();
                if (onFrontAdListener != null) {
                    onFrontAdListener.onAdClicked(2);
                }
            }
        });
        admobFrontAD.setAdUnitId(admobKey);
        admobFrontAD.loadAd(TedAdHelper.getAdRequest());
    }

    private static void showTnkFrontAd() {
        TnkSession.prepareInterstitialAd((Activity)((Activity)activityRef.get()), (String)"__tnk_cpc__", (TnkAdListener)new TnkAdListener(){

            public void onClose(int type) {
                Log.d((String)"TedAdHelper", (String)"[TNK FRONT AD]onClose");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onDismissed(3);
                }
            }

            public void onFailure(int errCode) {
                String errorMessage = TedAdHelper.getMessageFromTnkErrorCode(errCode);
                Log.e((String)"TedAdHelper", (String)("[TANK FRONT AD]" + errorMessage));
                TedAdFront.onError(errorMessage);
            }

            public void onLoad() {
                Log.d((String)"TedAdHelper", (String)"[TNK FRONT AD]onLoad");
                TnkSession.showInterstitialAd((Activity)((Activity)activityRef.get()));
                if (onFrontAdListener != null) {
                    onFrontAdListener.onLoaded(3);
                }
            }

            public void onShow() {
                Log.d((String)"TedAdHelper", (String)"[TNK FRONT AD]onShow");
            }
        });
    }

    private static void onClose() {
    }

    private static void onError(String errorMessage) {
        if (adPriorityList != null && adPriorityList.size() > 0) {
            TedAdFront.selectAd();
        } else {
            if (onFrontAdListener != null) {
                onFrontAdListener.onError(errorMessage);
            }
            TedAdFront.finishAd();
        }
    }

    private static void finishAd() {
        onFrontAdListener = null;
        facebookKey = null;
        admobKey = null;
        activityRef = null;
        adPriorityList = null;
    }
}

