/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import com.facebook.ads.AdSettings;
import com.google.android.gms.ads.AdRequest;
import gun0912.tedadhelper.util.AppUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TedAdHelper {
    public static final String TAG = "TedAdHelper";
    public static final int AD_FACEBOOK = 1;
    public static final int AD_ADMOB = 2;
    public static final int AD_TNK = 3;
    private static String admobDeviceId;
    private static boolean onlyFacebookInstalled;

    public static void setTestDeviceId(String facebookDeviceId, String admobDeviceId) {
        TedAdHelper.setFacebookTestDeviceId(facebookDeviceId);
        TedAdHelper.setAdmobTestDeviceId(admobDeviceId);
    }

    public static void setFacebookTestDeviceId(String deviceId) {
        AdSettings.addTestDevice((String)deviceId);
    }

    public static void setAdmobTestDeviceId(String deviceId) {
        admobDeviceId = deviceId;
    }

    public static void showAdOnlyFacebookInstalledUser(boolean value) {
        onlyFacebookInstalled = value;
    }

    public static AdRequest getAdRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        if (!TextUtils.isEmpty((CharSequence)admobDeviceId)) {
            builder.addTestDevice(admobDeviceId);
        }
        return builder.build();
    }

    public static boolean isSkipFacebookAd(Context context) {
        return onlyFacebookInstalled && !AppUtil.isExistApp(context, "com.facebook.katana");
    }

    public static String getMessageFromAdmobErrorCode(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "an invalid response was received from the ad server";
            }
            case 1: {
                return "ad unit ID was incorrect";
            }
            case 2: {
                return "The ad request was unsuccessful due to network connectivity";
            }
            case 3: {
                return "The ad request was successful, but no ad was returned due to lack of ad inventory";
            }
        }
        return "";
    }

    public static String getMessageFromTnkErrorCode(int errorCode) {
        switch (errorCode) {
            case -1: {
                return "\uc81c\uacf5\ud560 \uad11\uace0\uac00 \uc5c6\uc744 \uacbd\uc6b0 \ub610\ub294 \ud574\ub2f9 \uad11\uace0\uc571\uc774 \uc774\ubbf8 \uc0ac\uc6a9\uc790 \ub2e8\ub9d0\uae30\uc5d0 \uc124\uce58\ub418\uc5b4 \uc788\ub294 \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
            }
            case -2: {
                return "\uad11\uace0\ub97c \uac00\uc838\uc654\uc73c\ub098 \uc804\uba74 \uc774\ubbf8\uc9c0 \uc815\ubcf4\uac00 \uc5c6\ub294 \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
            }
            case -3: {
                return "showInterstitialAd() \ud638\ucd9c \ud6c4 \uc9c0\uc815\ub41c timeoout\uc2dc\uac04 (\uae30\ubcf8\uac12 5\ucd08) \uc774\ub0b4\uc5d0 \uc804\uba74\uad11\uace0\uac00 \ub3c4\ucc29\ud558\uc9c0 \uc54a\uc740 \uacbd\uc6b0\uc785\ub2c8\ub2e4. \uc774 \uacbd\uc6b0\uc5d0\ub294 \uc804\uba74\uad11\uace0\ub97c \ub744\uc6b0\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
            }
            case -4: {
                return "prepareInterstitialAd() \ud638\ucd9c\ud558\uc600\uc73c\ub098 \uc11c\ubc84\uc5d0\uc11c \uc124\uc815\ud55c \uad11\uace0 \ub178\ucd9c \uc8fc\uae30\ub97c \uc9c0\ub098\uc9c0 \uc54a\uc544 \ucde8\uc18c\ub41c \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
            }
            case -5: {
                return "prepareInterstitialAd()\ub97c \ud638\ucd9c\ud558\uc9c0 \uc54a\uace0 showInterstitialAd()\ub97c \ud638\ucd9c\ud55c \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
            }
            case -9: {
                return "prepareInterstitialAd()\ub97c \ud638\ucd9c\ud558\uc9c0 \uc54a\uace0 showInterstitialAd()\ub97c \ud638\ucd9c\ud55c \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
            }
        }
        return "";
    }

    static {
        onlyFacebookInstalled = false;
    }

    public static interface ImageProvider {
        public void onProvideImage(ImageView var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ADMOB_NATIVE_AD_TYPE {
        public static final int NATIVE_EXPRESS = 1;
        public static final int NATIVE_ADVANCED = 2;
        public static final int BANNER = 3;
    }
}

