/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.front;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAdListener;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.front.OnFrontAdListener;

public class TedAdFront {
    private static OnFrontAdListener onFrontAdListener;
    private static String facebookKey;
    private static String admobKey;
    private static Context context;

    public static void showFacebookFrontAd(Context context, String facebookKey, OnFrontAdListener onFrontAdListener) {
        TedAdFront.showFrontAD(context, facebookKey, null, 1, onFrontAdListener);
    }

    public static void showAdmobFrontAd(Context context, String admobKey, OnFrontAdListener onFrontAdListener) {
        TedAdFront.showFrontAD(context, null, admobKey, 2, onFrontAdListener);
    }

    public static void showFrontAD(Context context, String facebookKey, String admobKey, int adPriority, OnFrontAdListener onFrontAdListener) {
        block6: {
            try {
                TedAdFront.context = context;
                TedAdFront.facebookKey = facebookKey;
                TedAdFront.admobKey = admobKey;
                TedAdFront.onFrontAdListener = onFrontAdListener;
                switch (adPriority) {
                    case 1: {
                        TedAdFront.showFacebookFrontAd(!TextUtils.isEmpty((CharSequence)admobKey));
                        break;
                    }
                    case 2: {
                        TedAdFront.showAdmobFrontAd(!TextUtils.isEmpty((CharSequence)facebookKey));
                        break;
                    }
                    default: {
                        throw new RuntimeException("You have to select priority type ADMOB or FACEBOOK");
                    }
                }
            }
            catch (Exception e) {
                if (onFrontAdListener == null) break block6;
                onFrontAdListener.onError("");
            }
        }
    }

    private static void showFacebookFrontAd(final boolean failToAdmob) {
        final com.facebook.ads.InterstitialAd facebookFrontAD = new com.facebook.ads.InterstitialAd(context, facebookKey);
        if (onFrontAdListener != null) {
            onFrontAdListener.onFacebookAdCreated(facebookFrontAD);
        }
        facebookFrontAD.setAdListener(new InterstitialAdListener(){

            public void onInterstitialDisplayed(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Displayed");
            }

            public void onInterstitialDismissed(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Dismissed");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onDismissed(1);
                }
            }

            public void onError(Ad ad, AdError adError) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK FRONT AD]Error: " + adError.getErrorMessage()));
                if (failToAdmob) {
                    TedAdFront.showAdmobFrontAd(false);
                } else if (onFrontAdListener != null) {
                    onFrontAdListener.onError(adError.getErrorMessage());
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Loaded");
                facebookFrontAD.show();
                if (onFrontAdListener != null) {
                    onFrontAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK FRONT AD]Clicked");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onAdClicked(1);
                }
            }
        });
        facebookFrontAD.loadAd();
    }

    private static void showAdmobFrontAd(final boolean failToFacebook) {
        final InterstitialAd admobFrontAD = new InterstitialAd(context);
        admobFrontAD.setAdListener(new AdListener(){

            public void onAdClosed() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Dismissed");
                if (onFrontAdListener != null) {
                    onFrontAdListener.onDismissed(2);
                }
            }

            public void onAdFailedToLoad(int errorCode) {
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                Log.e((String)"TedAdHelper", (String)("[ADMOB FRONT AD]Error: " + errorMessage));
                if (failToFacebook) {
                    TedAdFront.showFacebookFrontAd(false);
                } else if (onFrontAdListener != null) {
                    onFrontAdListener.onError(errorMessage);
                }
            }

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Loaded");
                admobFrontAD.show();
                if (onFrontAdListener != null) {
                    onFrontAdListener.onLoaded(2);
                }
            }

            public void onAdLeftApplication() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB FRONT AD]Clicked");
                super.onAdLeftApplication();
                if (onFrontAdListener != null) {
                    onFrontAdListener.onAdClicked(2);
                }
            }
        });
        admobFrontAD.setAdUnitId(admobKey);
        admobFrontAD.loadAd(new AdRequest.Builder().build());
    }
}

