/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.banner;

import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.banner.OnBannerAdListener;

public class TedAdBanner {
    private static OnBannerAdListener onBannerAdListener;
    private static String facebookKey;
    private static String admobKey;
    private static ViewGroup bannerContainer;

    public static void showFacebookBanner(ViewGroup bannerContainer, String facebookKey, OnBannerAdListener onBannerAdListener) {
        TedAdBanner.showBanner(bannerContainer, facebookKey, null, 1, onBannerAdListener);
    }

    public static void showAdmobBanner(ViewGroup bannerContainer, String admobKey, OnBannerAdListener onBannerAdListener) {
        TedAdBanner.showBanner(bannerContainer, null, admobKey, 2, onBannerAdListener);
    }

    public static void showBanner(ViewGroup bannerContainer, String facebookKey, String admobKey, int adPriority, OnBannerAdListener onBannerAdListener) {
        block7: {
            try {
                TedAdBanner.facebookKey = facebookKey;
                TedAdBanner.admobKey = admobKey;
                TedAdBanner.onBannerAdListener = onBannerAdListener;
                TedAdBanner.bannerContainer = bannerContainer;
                if (bannerContainer == null) {
                    throw new RuntimeException("BannerContainer can not null");
                }
                switch (adPriority) {
                    case 2: {
                        TedAdBanner.showAdmobBanner(!TextUtils.isEmpty((CharSequence)facebookKey));
                        break;
                    }
                    case 1: {
                        TedAdBanner.showFacebookBanner(!TextUtils.isEmpty((CharSequence)admobKey));
                        break;
                    }
                    default: {
                        throw new RuntimeException("You have to select priority type ADMOB or FACEBOOK");
                    }
                }
            }
            catch (Exception e) {
                if (onBannerAdListener == null) break block7;
                onBannerAdListener.onError("");
            }
        }
    }

    private static void showFacebookBanner(final boolean failToAdmob) {
        final AdView facebookBanner = new AdView(bannerContainer.getContext(), facebookKey, AdSize.BANNER_HEIGHT_50);
        if (onBannerAdListener != null) {
            onBannerAdListener.onFacebookAdCreated(facebookBanner);
        }
        facebookBanner.setAdListener(new com.facebook.ads.AdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK BANNER]Error: " + adError.getErrorMessage()));
                if (failToAdmob) {
                    TedAdBanner.showAdmobBanner(false);
                } else if (onBannerAdListener != null) {
                    onBannerAdListener.onError(adError.getErrorMessage());
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK BANNER]Loaded");
                bannerContainer.removeAllViews();
                ViewGroup parentView = (ViewGroup)facebookBanner.getParent();
                if (parentView != null) {
                    parentView.removeAllViews();
                }
                bannerContainer.addView((View)facebookBanner);
                if (onBannerAdListener != null) {
                    onBannerAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK BANNER]Clicked");
                if (onBannerAdListener != null) {
                    onBannerAdListener.onAdClicked(1);
                }
            }
        });
        facebookBanner.loadAd();
    }

    private static void showAdmobBanner(final boolean failToFacebook) {
        final com.google.android.gms.ads.AdView admobBanner = new com.google.android.gms.ads.AdView(bannerContainer.getContext());
        admobBanner.setAdSize(com.google.android.gms.ads.AdSize.SMART_BANNER);
        admobBanner.setAdUnitId(admobKey);
        AdRequest adRequest = new AdRequest.Builder().build();
        admobBanner.loadAd(adRequest);
        admobBanner.setAdListener(new AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                Log.e((String)"TedAdHelper", (String)("[ADMOB BANNER]Error: " + errorMessage));
                if (failToFacebook) {
                    TedAdBanner.showFacebookBanner(false);
                } else if (onBannerAdListener != null) {
                    onBannerAdListener.onError(errorMessage);
                }
            }

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB BANNER]Loaded");
                bannerContainer.removeAllViews();
                bannerContainer.addView((View)admobBanner);
                if (onBannerAdListener != null) {
                    onBannerAdListener.onLoaded(2);
                }
            }

            public void onAdLeftApplication() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB BANNER]Clicked");
                super.onAdLeftApplication();
                if (onBannerAdListener != null) {
                    onBannerAdListener.onAdClicked(2);
                }
            }
        });
    }
}

