/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.backpress;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import gun0912.tedadhelper.R;
import gun0912.tedadhelper.backpress.OnBackPressListener;
import gun0912.tedadhelper.nativead.OnNativeAdListener;
import gun0912.tedadhelper.nativead.TedNativeAdHolder;
import gun0912.tedadhelper.util.AppUtil;
import gun0912.tedadhelper.util.SharedPreferenceUtil;

public class TedBackPressDialog
extends AppCompatActivity {
    private static final String EXTRA_APP_NAME = "app_name";
    private static final String EXTRA_FACEBOOK_KEY = "facebook_key";
    private static final String EXTRA_ADMOB_KEY = "admob_key";
    private static final String EXTRA_AD_PRIORITY = "ad_priority";
    private static OnBackPressListener onBackPressListener;
    View adview_container;
    TextView tvFinish;
    TextView tvReview;
    String appName;
    String facebookKey;
    String admobKey;
    int adPriority;

    public static void startFacebookDialog(Activity activity, String appName, String facebookKey, OnBackPressListener onBackPressListener) {
        TedBackPressDialog.startDialog(activity, appName, facebookKey, null, 1, onBackPressListener);
    }

    public static void startDialog(Activity activity, String appName, String facebookKey, String admobKey, int adPriority, OnBackPressListener onBackPressListener) {
        Intent intent = new Intent((Context)activity, TedBackPressDialog.class);
        intent.putExtra(EXTRA_APP_NAME, appName);
        intent.putExtra(EXTRA_FACEBOOK_KEY, facebookKey);
        intent.putExtra(EXTRA_ADMOB_KEY, admobKey);
        intent.putExtra(EXTRA_AD_PRIORITY, adPriority);
        if (onBackPressListener == null) {
            throw new RuntimeException("OnBackPressListener can not null");
        }
        TedBackPressDialog.onBackPressListener = onBackPressListener;
        activity.startActivity(intent);
        activity.overridePendingTransition(0, 0);
    }

    public static void startAdmobDialog(Activity activity, String appName, String admobKey, OnBackPressListener onBackPressListener) {
        TedBackPressDialog.startDialog(activity, appName, null, admobKey, 2, onBackPressListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        int width;
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        super.onCreate(savedInstanceState);
        this.setupFromSavedInstanceState(savedInstanceState);
        this.setContentView(R.layout.dialog_backpress);
        Display display = ((WindowManager)this.getSystemService("window")).getDefaultDisplay();
        this.getWindow().getAttributes().width = width = (int)((double)display.getWidth() * 0.9);
        this.setFinishOnTouchOutside(false);
        this.initView();
        TedNativeAdHolder adViewNativeAdHolder = new TedNativeAdHolder(this.adview_container, (Context)this, this.appName, this.facebookKey, this.admobKey);
        adViewNativeAdHolder.loadAD(this.adPriority, new OnNativeAdListener(){

            @Override
            public void onError(String errorMessage) {
                if (onBackPressListener != null) {
                    onBackPressListener.onError(errorMessage);
                }
            }

            @Override
            public void onLoaded(int adType) {
                if (onBackPressListener != null) {
                    onBackPressListener.onLoaded(adType);
                }
            }

            @Override
            public void onAdClicked(int adType) {
                if (onBackPressListener != null) {
                    onBackPressListener.onAdClicked(adType);
                }
            }
        });
        this.checkReview();
    }

    private void checkReview() {
        boolean isReview = SharedPreferenceUtil.getSharedPreference((Context)this, "review", false);
        if (isReview) {
            this.tvReview.setVisibility(8);
        }
    }

    private void setupFromSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.appName = savedInstanceState.getString(EXTRA_APP_NAME);
            this.facebookKey = savedInstanceState.getString(EXTRA_FACEBOOK_KEY);
            this.admobKey = savedInstanceState.getString(EXTRA_ADMOB_KEY);
            this.adPriority = savedInstanceState.getInt(EXTRA_AD_PRIORITY);
        } else {
            this.appName = this.getIntent().getStringExtra(EXTRA_APP_NAME);
            this.facebookKey = this.getIntent().getStringExtra(EXTRA_FACEBOOK_KEY);
            this.admobKey = this.getIntent().getStringExtra(EXTRA_ADMOB_KEY);
            this.adPriority = this.getIntent().getIntExtra(EXTRA_AD_PRIORITY, 0);
        }
    }

    private void initView() {
        this.adview_container = this.findViewById(R.id.adview_container);
        this.tvReview = (TextView)this.findViewById(R.id.tv_review);
        this.tvReview.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TedBackPressDialog.this.onReviewClick();
            }
        });
        this.tvFinish = (TextView)this.findViewById(R.id.tv_finish);
        this.tvFinish.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TedBackPressDialog.this.onFinishClick();
            }
        });
    }

    private void onReviewClick() {
        AppUtil.openPlayStore((Context)this, this.getPackageName());
        SharedPreferenceUtil.putSharedPreference((Context)this, "review", true);
        if (onBackPressListener != null) {
            onBackPressListener.onReviewClick();
        }
    }

    private void onFinishClick() {
        this.finish();
        this.overridePendingTransition(0, 0);
        if (onBackPressListener != null) {
            onBackPressListener.onFinish();
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString(EXTRA_APP_NAME, this.appName);
        savedInstanceState.putString(EXTRA_FACEBOOK_KEY, this.facebookKey);
        savedInstanceState.putString(EXTRA_ADMOB_KEY, this.admobKey);
        savedInstanceState.putInt(EXTRA_AD_PRIORITY, this.adPriority);
    }

    public void onBackPressed() {
        this.finish();
        this.overridePendingTransition(0, 0);
    }
}

