/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.util;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.widget.ImageView;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestListener;

public class ImageUtil {
    public static void loadImage(ImageView imageView, String url) {
        ImageUtil.loadImage(imageView, url, false, false, -1, -1, null);
    }

    public static void loadImage(ImageView imageView, int res_id, RequestListener callback) {
        Glide.with((Context)imageView.getContext()).load(Integer.valueOf(res_id)).dontAnimate().listener(callback).into(imageView);
    }

    public static void loadImage(ImageView imageView, String url, boolean thumbnail, boolean centerCrop, int holder_resId, int err_resId, RequestListener callback) {
        Context context = imageView.getContext();
        if (context == null) {
            return;
        }
        if (context instanceof Activity) {
            if (((Activity)context).isFinishing()) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 17 && ((Activity)context).isDestroyed()) {
                return;
            }
        }
        try {
            if (!ImageUtil.checkWebUrl(imageView, url, err_resId, callback)) {
                return;
            }
            DrawableTypeRequest request = Glide.with((Context)context).load(url);
            if (holder_resId > 0) {
                request.placeholder(holder_resId);
            }
            if (err_resId > 0) {
                request.error(err_resId);
            }
            if (thumbnail) {
                request.thumbnail(0.1f);
            }
            if (centerCrop) {
                request.centerCrop();
            }
            if (url.endsWith(".gif")) {
                Glide.with((Context)context).load(url).asGif().dontAnimate().diskCacheStrategy(DiskCacheStrategy.SOURCE).priority(Priority.IMMEDIATE).into(imageView);
            } else {
                request.asBitmap();
            }
            if (callback != null) {
                request.listener(callback);
            }
            request.diskCacheStrategy(DiskCacheStrategy.SOURCE).priority(Priority.IMMEDIATE).dontAnimate().into(imageView);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean checkWebUrl(ImageView imageView, String url, int err_resId, RequestListener callback) {
        Context context = imageView.getContext();
        try {
            if (TextUtils.isEmpty((CharSequence)url)) {
                Glide.with((Context)context).load(Integer.valueOf(err_resId)).dontAnimate().listener(callback).into(imageView);
                return false;
            }
            if (!url.startsWith("http")) {
                Glide.with((Context)context).load(url).error(err_resId).dontAnimate().listener(callback).into(imageView);
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

