/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.nativead;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.NativeExpressAdView;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeAppInstallAdView;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeContentAdView;
import gun0912.tedadhelper.R;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.nativead.OnNativeAdListener;
import gun0912.tedadhelper.util.ConvertUtil;
import gun0912.tedadhelper.util.ImageUtil;
import java.util.List;

public class TedNativeAdHolder
extends RecyclerView.ViewHolder {
    String app_name;
    String facebook_ad_key;
    String admob_ad_key;
    Context context;
    NativeAppInstallAdView admobAppInstallRootView;
    NativeContentAdView admobContentRootView;
    ViewGroup container_admob_express;
    ProgressBar progressView;
    View view_root;
    View view_container;
    ImageView ivLogo;
    TextView tvName;
    TextView tvBody;
    MediaView nativeAdMedia;
    ImageView ivImage;
    TextView tvEtc;
    TextView tvCallToAction;
    NativeAd facebookAd;
    OnNativeAdListener onNativeAdListener;

    public TedNativeAdHolder(View itemView, Context context, String app_name, String facebook_ad_key, String admob_ad_key) {
        super(itemView);
        this.context = context;
        this.app_name = app_name;
        this.facebook_ad_key = facebook_ad_key;
        this.admob_ad_key = admob_ad_key;
        this.initView();
    }

    private void initView() {
        this.view_root = this.itemView.findViewById(R.id.view_root);
        this.admobAppInstallRootView = (NativeAppInstallAdView)this.itemView.findViewById(R.id.admobAppInstallRootView);
        this.admobContentRootView = (NativeContentAdView)this.itemView.findViewById(R.id.admobContentRootView);
        this.container_admob_express = (ViewGroup)this.itemView.findViewById(R.id.container_admob_express);
        this.progressView = (ProgressBar)this.itemView.findViewById(R.id.progressView);
        this.view_container = this.itemView.findViewById(R.id.view_container);
        this.ivLogo = (ImageView)this.itemView.findViewById(R.id.iv_logo);
        this.tvName = (TextView)this.itemView.findViewById(R.id.tv_name);
        this.tvBody = (TextView)this.itemView.findViewById(R.id.tv_body);
        this.nativeAdMedia = (MediaView)this.itemView.findViewById(R.id.native_ad_media);
        this.ivImage = (ImageView)this.itemView.findViewById(R.id.iv_image);
        this.tvEtc = (TextView)this.itemView.findViewById(R.id.tv_etc);
        this.tvCallToAction = (TextView)this.itemView.findViewById(R.id.tv_call_to_action);
    }

    public void loadFacebookAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(1, onNativeAdListener);
    }

    public void loadAdmobAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(2, onNativeAdListener);
    }

    public void loadAD(int adPriority, OnNativeAdListener onNativeAdListener) {
        this.onNativeAdListener = onNativeAdListener;
        switch (adPriority) {
            case 1: {
                this.loadFacebookAD(!TextUtils.isEmpty((CharSequence)this.admob_ad_key));
                break;
            }
            case 2: {
                this.loadAdmobExpressAD(!TextUtils.isEmpty((CharSequence)this.facebook_ad_key));
                break;
            }
            default: {
                throw new RuntimeException("You have to select priority type ADMOB or FACEBOOK");
            }
        }
    }

    private void loadAdmobExpressAD(final boolean failToFacebookAD) {
        this.progressView.setVisibility(0);
        final NativeExpressAdView admobExpressAdView = new NativeExpressAdView(this.context);
        admobExpressAdView.setVideoOptions(new VideoOptions.Builder().setStartMuted(true).build());
        admobExpressAdView.setAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE AD]Loaded");
                TedNativeAdHolder.this.view_container.setVisibility(8);
                TedNativeAdHolder.this.progressView.setVisibility(8);
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onLoaded(2);
                }
            }

            public void onAdFailedToLoad(int errorCode) {
                Log.e((String)"TedAdHelper", (String)("[ADMOB NATIVE AD]Error code: " + errorCode));
                super.onAdFailedToLoad(errorCode);
                if (failToFacebookAD) {
                    TedNativeAdHolder.this.loadFacebookAD(false);
                } else {
                    TedNativeAdHolder.this.view_root.setVisibility(8);
                    if (TedNativeAdHolder.this.onNativeAdListener != null) {
                        String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                        TedNativeAdHolder.this.onNativeAdListener.onError(errorMessage);
                    }
                }
            }

            public void onAdOpened() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE AD]Opend");
                super.onAdOpened();
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onAdClicked(2);
                }
            }
        });
        this.container_admob_express.post(new Runnable(){

            @Override
            public void run() {
                int realWidth = ConvertUtil.pxToDp(TedNativeAdHolder.this.context, TedNativeAdHolder.this.container_admob_express.getWidth());
                int realHeight = 320 * realWidth / 360;
                if (admobExpressAdView.getAdUnitId() == null) {
                    admobExpressAdView.setAdUnitId(TedNativeAdHolder.this.admob_ad_key);
                }
                if (admobExpressAdView.getAdSize() == null) {
                    admobExpressAdView.setAdSize(new AdSize(realWidth, realHeight));
                }
                for (int i = 0; i < TedNativeAdHolder.this.container_admob_express.getChildCount(); ++i) {
                    if (!(TedNativeAdHolder.this.container_admob_express.getChildAt(i) instanceof NativeExpressAdView)) continue;
                    NativeExpressAdView temp = (NativeExpressAdView)TedNativeAdHolder.this.container_admob_express.getChildAt(i);
                    temp.destroy();
                }
                TedNativeAdHolder.this.container_admob_express.removeAllViews();
                TedNativeAdHolder.this.container_admob_express.addView((View)admobExpressAdView);
                admobExpressAdView.loadAd(new AdRequest.Builder().build());
            }
        });
    }

    private void loadAdmobAdvanceAD(final boolean failToFacebookAD) {
        AdLoader.Builder builder = new AdLoader.Builder(this.context, this.admob_ad_key);
        builder.forAppInstallAd(new NativeAppInstallAd.OnAppInstallAdLoadedListener(){

            public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
                TedNativeAdHolder.this.bindAdmobAppInstallAD(nativeAppInstallAd);
            }
        });
        builder.forContentAd(new NativeContentAd.OnContentAdLoadedListener(){

            public void onContentAdLoaded(NativeContentAd nativeContentAd) {
                TedNativeAdHolder.this.bindAdmobContentAD(nativeContentAd);
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                super.onAdFailedToLoad(errorCode);
                if (failToFacebookAD) {
                    TedNativeAdHolder.this.loadFacebookAD(false);
                } else {
                    TedNativeAdHolder.this.view_root.setVisibility(8);
                    if (TedNativeAdHolder.this.onNativeAdListener != null) {
                        String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                        TedNativeAdHolder.this.onNativeAdListener.onError(errorMessage);
                    }
                }
            }
        }).build();
        AdRequest.Builder requestBuilder = new AdRequest.Builder();
        adLoader.loadAd(requestBuilder.build());
    }

    private void loadFacebookAD(final boolean failToAdmobAD) {
        this.progressView.setVisibility(0);
        this.facebookAd = new NativeAd(this.context, this.facebook_ad_key);
        this.facebookAd.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError error) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK NATIVE AD]Error: " + error.getErrorMessage()));
                if (failToAdmobAD) {
                    TedNativeAdHolder.this.loadAdmobExpressAD(false);
                } else {
                    TedNativeAdHolder.this.view_root.setVisibility(8);
                    if (TedNativeAdHolder.this.onNativeAdListener != null) {
                        TedNativeAdHolder.this.onNativeAdListener.onError(error.getErrorMessage());
                    }
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Loaded");
                TedNativeAdHolder.this.bindFacebookAD(ad);
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Clicked");
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onAdClicked(1);
                }
            }
        });
        this.facebookAd.loadAd();
    }

    private void bindFacebookAD(Ad ad) {
        if (this.facebookAd != ad) {
            this.view_root.setVisibility(8);
            return;
        }
        MyNativeAd myNativeAd = new MyNativeAd();
        if (this.facebookAd.getAdIcon() != null) {
            myNativeAd.setLogoUrl(this.facebookAd.getAdIcon().getUrl());
        }
        myNativeAd.setName(this.facebookAd.getAdTitle());
        if (this.facebookAd.getAdCoverImage() != null) {
            myNativeAd.setImageUrl(this.facebookAd.getAdCoverImage().getUrl());
        }
        myNativeAd.setBody(this.facebookAd.getAdBody());
        myNativeAd.setCallToAction(this.facebookAd.getAdCallToAction());
        myNativeAd.setEtc(this.facebookAd.getAdSocialContext());
        this.bindNativeAd(myNativeAd);
        this.nativeAdMedia.setNativeAd(this.facebookAd);
        this.facebookAd.unregisterView();
        this.facebookAd.registerViewForInteraction(this.view_root);
        this.view_root.setVisibility(0);
        this.view_container.setVisibility(0);
        this.container_admob_express.setVisibility(8);
        this.progressView.setVisibility(8);
    }

    private void bindAdmobContentAD(NativeContentAd nativeContentAd) {
        MyNativeAd myNativeAd = new MyNativeAd();
        myNativeAd.setLogoUrl(nativeContentAd.getLogo().getUri().toString());
        myNativeAd.setName(nativeContentAd.getHeadline().toString());
        List images = nativeContentAd.getImages();
        if (images.size() > 0) {
            myNativeAd.setImageUrl(((NativeAd.Image)nativeContentAd.getImages().get(0)).getUri().toString());
        }
        myNativeAd.setBody(nativeContentAd.getBody().toString());
        myNativeAd.setCallToAction(nativeContentAd.getCallToAction().toString());
        myNativeAd.setEtc(nativeContentAd.getAdvertiser().toString());
        this.bindNativeAd(myNativeAd);
        this.admobContentRootView.setNativeAd((com.google.android.gms.ads.formats.NativeAd)nativeContentAd);
    }

    private void bindAdmobAppInstallAD(NativeAppInstallAd nativeAppInstallAd) {
        MyNativeAd myNativeAd = new MyNativeAd();
        myNativeAd.setLogoUrl(nativeAppInstallAd.getIcon().getUri().toString());
        myNativeAd.setName(nativeAppInstallAd.getHeadline().toString());
        List images = nativeAppInstallAd.getImages();
        if (images.size() > 0) {
            myNativeAd.setImageUrl(((NativeAd.Image)nativeAppInstallAd.getImages().get(0)).getUri().toString());
        }
        myNativeAd.setBody(nativeAppInstallAd.getBody().toString());
        myNativeAd.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
        myNativeAd.setEtc(nativeAppInstallAd.getStore().toString());
        this.bindNativeAd(myNativeAd);
        this.admobAppInstallRootView.setNativeAd((com.google.android.gms.ads.formats.NativeAd)nativeAppInstallAd);
    }

    private void bindNativeAd(MyNativeAd myNativeAd) {
        String logoUrl = myNativeAd.getLogoUrl();
        ImageUtil.loadImage(this.ivLogo, logoUrl);
        String name = myNativeAd.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = this.app_name + " \uad11\uace0";
        }
        this.tvName.setText((CharSequence)name);
        String imageUrl = myNativeAd.getImageUrl();
        ImageUtil.loadImage(this.ivImage, imageUrl);
        String body = myNativeAd.getBody();
        if (!TextUtils.isEmpty((CharSequence)body)) {
            this.tvBody.setText((CharSequence)body);
        }
        this.tvEtc.setText((CharSequence)myNativeAd.getEtc());
        this.tvCallToAction.setText((CharSequence)myNativeAd.getCallToAction());
        this.view_root.setVisibility(0);
    }

    class MyNativeAd {
        String logoUrl;
        String name;
        String imageUrl;
        String body;
        String callToAction;
        String etc;

        MyNativeAd() {
        }

        public String getLogoUrl() {
            return this.logoUrl;
        }

        public void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getCallToAction() {
            return this.callToAction;
        }

        public void setCallToAction(String callToAction) {
            this.callToAction = callToAction;
        }

        public String getEtc() {
            return this.etc;
        }

        public void setEtc(String etc) {
            this.etc = etc;
        }
    }
}

