/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.nativead;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.NativeExpressAdView;
import com.google.android.gms.ads.VideoOptions;
import com.tnkfactory.ad.NativeAdItem;
import com.tnkfactory.ad.NativeAdListener;
import com.tnkfactory.ad.TnkSession;
import gun0912.tedadhelper.R;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.nativead.OnNativeAdListener;
import gun0912.tedadhelper.util.ConvertUtil;
import gun0912.tedadhelper.util.ImageUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class TedNativeAdHolder
extends RecyclerView.ViewHolder {
    ArrayList<Integer> adPriorityList;
    String app_name;
    String facebook_ad_key;
    String admob_ad_key;
    Context context;
    ViewGroup container_admob_express;
    ProgressBar progressView;
    RelativeLayout view_root;
    LinearLayout view_container;
    ImageView ivLogo;
    TextView tvName;
    TextView tvBody;
    MediaView nativeAdMedia;
    ImageView ivImage;
    TextView tvEtc;
    TextView tvCallToAction;
    NativeAd facebookAd;
    OnNativeAdListener onNativeAdListener;

    public TedNativeAdHolder(View itemView, Context context, String app_name, String facebook_ad_key, String admob_ad_key) {
        super(itemView);
        this.context = context;
        this.app_name = app_name;
        this.facebook_ad_key = facebook_ad_key;
        this.admob_ad_key = admob_ad_key;
        this.initView();
    }

    private void initView() {
        this.view_root = (RelativeLayout)this.itemView.findViewById(R.id.view_root);
        this.container_admob_express = (ViewGroup)this.itemView.findViewById(R.id.container_admob_express);
        this.progressView = (ProgressBar)this.itemView.findViewById(R.id.progressView);
        this.view_container = (LinearLayout)this.itemView.findViewById(R.id.view_container);
        this.ivLogo = (ImageView)this.itemView.findViewById(R.id.iv_logo);
        this.tvName = (TextView)this.itemView.findViewById(R.id.tv_name);
        this.tvBody = (TextView)this.itemView.findViewById(R.id.tv_body);
        this.nativeAdMedia = (MediaView)this.itemView.findViewById(R.id.native_ad_media);
        this.ivImage = (ImageView)this.itemView.findViewById(R.id.iv_image);
        this.tvEtc = (TextView)this.itemView.findViewById(R.id.tv_etc);
        this.tvCallToAction = (TextView)this.itemView.findViewById(R.id.tv_call_to_action);
    }

    public void onDestroy() {
        if (this.nativeAdMedia != null) {
            this.nativeAdMedia.destroy();
        }
        if (this.facebookAd != null) {
            this.facebookAd.destroy();
        }
    }

    public void loadFacebookAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(1, onNativeAdListener);
    }

    public void loadAdmobAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(2, onNativeAdListener);
    }

    public void loadAD(int adPriority, OnNativeAdListener onNativeAdListener) {
        Integer[] tempAdPriorityList = new Integer[]{adPriority, adPriority == 1 ? Integer.valueOf(2) : Integer.valueOf(1)};
        this.loadAD(tempAdPriorityList, onNativeAdListener);
    }

    public void loadAD(Integer[] tempAdPriorityList, OnNativeAdListener onNativeAdListener) {
        if (tempAdPriorityList == null || tempAdPriorityList.length == 0) {
            throw new RuntimeException("You have to select priority type ADMOB/FACEBOOK/TNK");
        }
        ArrayList<Integer> resultTempAdPriorityList = new ArrayList<Integer>(Arrays.asList(tempAdPriorityList));
        this.loadAD(resultTempAdPriorityList, onNativeAdListener);
    }

    public void loadAD(ArrayList tempAdPriorityList, OnNativeAdListener onNativeAdListener) {
        block3: {
            this.onNativeAdListener = onNativeAdListener;
            if (tempAdPriorityList == null || tempAdPriorityList.size() == 0) {
                throw new RuntimeException("You have to select priority type ADMOB/FACEBOOK/TNK");
            }
            this.adPriorityList = tempAdPriorityList;
            try {
                this.selectAd();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (onNativeAdListener == null) break block3;
                onNativeAdListener.onError(e.toString());
            }
        }
    }

    private void selectAd() {
        int adPriority = this.adPriorityList.remove(0);
        switch (adPriority) {
            case 1: {
                this.loadFacebookAD();
                break;
            }
            case 2: {
                this.loadAdmobExpressAD();
                break;
            }
            case 3: {
                this.loadTnkAD();
                break;
            }
            default: {
                throw new IllegalArgumentException("You have to select priority type ADMOB or FACEBOOK");
            }
        }
    }

    private void onLoadAdError(String errorMessage) {
        if (this.adPriorityList.size() > 0) {
            this.selectAd();
        } else {
            this.view_root.setVisibility(8);
            if (this.onNativeAdListener != null) {
                this.onNativeAdListener.onError(errorMessage);
            }
        }
    }

    private void loadAdmobExpressAD() {
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(8);
        final NativeExpressAdView admobExpressAdView = new NativeExpressAdView(this.context);
        admobExpressAdView.setVideoOptions(new VideoOptions.Builder().setStartMuted(true).build());
        admobExpressAdView.setAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE AD]Loaded");
                TedNativeAdHolder.this.view_container.setVisibility(8);
                TedNativeAdHolder.this.progressView.setVisibility(8);
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onLoaded(2);
                }
            }

            public void onAdFailedToLoad(int errorCode) {
                Log.e((String)"TedAdHelper", (String)("[ADMOB NATIVE AD]Error code: " + errorCode));
                super.onAdFailedToLoad(errorCode);
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                TedNativeAdHolder.this.onLoadAdError(errorMessage);
            }

            public void onAdOpened() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE AD]Opend");
                super.onAdOpened();
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onAdClicked(2);
                }
            }
        });
        this.container_admob_express.post(new Runnable(){

            @Override
            public void run() {
                int realWidth = ConvertUtil.pxToDp(TedNativeAdHolder.this.context, TedNativeAdHolder.this.container_admob_express.getWidth());
                int realHeight = 320 * realWidth / 360;
                if (admobExpressAdView.getAdUnitId() == null) {
                    admobExpressAdView.setAdUnitId(TedNativeAdHolder.this.admob_ad_key);
                }
                if (admobExpressAdView.getAdSize() == null) {
                    admobExpressAdView.setAdSize(new AdSize(realWidth, realHeight));
                }
                for (int i = 0; i < TedNativeAdHolder.this.container_admob_express.getChildCount(); ++i) {
                    if (!(TedNativeAdHolder.this.container_admob_express.getChildAt(i) instanceof NativeExpressAdView)) continue;
                    NativeExpressAdView temp = (NativeExpressAdView)TedNativeAdHolder.this.container_admob_express.getChildAt(i);
                    temp.destroy();
                }
                TedNativeAdHolder.this.container_admob_express.removeAllViews();
                TedNativeAdHolder.this.container_admob_express.addView((View)admobExpressAdView);
                admobExpressAdView.loadAd(TedAdHelper.getAdRequest());
            }
        });
    }

    private void loadTnkAD() {
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(8);
        TnkSession.prepareNativeAd((Context)this.context, (String)"__tnk_cpc__", (int)2, (NativeAdListener)new NativeAdListener(){

            public void onFailure(int errCode) {
                String errorMessage = TedAdHelper.getMessageFromTnkErrorCode(errCode);
                Log.e((String)"TedAdHelper", (String)("[TANK NATIVE AD]" + errorMessage));
                TedNativeAdHolder.this.onLoadAdError(errorMessage);
            }

            public void onLoad(NativeAdItem adItem) {
                Log.d((String)"TedAdHelper", (String)"[TANK NATIVE AD]onLoad");
                TedNativeAdHolder.this.bindTnkAD(adItem);
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onLoaded(1);
                }
            }

            public void onClick() {
                Log.d((String)"TedAdHelper", (String)"[TANK NATIVE AD]onClick");
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onAdClicked(1);
                }
            }

            public void onShow() {
                Log.d((String)"TedAdHelper", (String)"[TANK NATIVE AD]onShow");
            }
        });
    }

    private void loadFacebookAD() {
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(8);
        this.facebookAd = new NativeAd(this.context, this.facebook_ad_key);
        this.facebookAd.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError error) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK NATIVE AD]Error: " + error.getErrorMessage()));
                TedNativeAdHolder.this.onLoadAdError(error.getErrorMessage());
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Loaded");
                TedNativeAdHolder.this.bindFacebookAD(ad);
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Clicked");
                if (TedNativeAdHolder.this.onNativeAdListener != null) {
                    TedNativeAdHolder.this.onNativeAdListener.onAdClicked(1);
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        this.facebookAd.loadAd();
    }

    private void bindTnkAD(NativeAdItem adItem) {
        MyNativeAd myNativeAd = new MyNativeAd();
        myNativeAd.setLogoUrl(adItem.getIconUrl());
        myNativeAd.setName(adItem.getTitle());
        myNativeAd.setImageUrl(adItem.getCoverImageUrl());
        myNativeAd.setBody(adItem.getDescription());
        this.bindNativeAd(myNativeAd);
        adItem.attachLayout((ViewGroup)this.view_root);
    }

    private void bindFacebookAD(Ad ad) {
        if (this.facebookAd != ad) {
            this.view_root.setVisibility(8);
            return;
        }
        MyNativeAd myNativeAd = new MyNativeAd();
        if (this.facebookAd.getAdIcon() != null) {
            myNativeAd.setLogoUrl(this.facebookAd.getAdIcon().getUrl());
        }
        myNativeAd.setName(this.facebookAd.getAdTitle());
        if (this.facebookAd.getAdCoverImage() != null) {
            myNativeAd.setImageUrl(this.facebookAd.getAdCoverImage().getUrl());
            this.nativeAdMedia.setVisibility(8);
        }
        myNativeAd.setBody(this.facebookAd.getAdBody());
        myNativeAd.setCallToAction(this.facebookAd.getAdCallToAction());
        myNativeAd.setEtc(this.facebookAd.getAdSocialContext());
        this.bindNativeAd(myNativeAd);
        this.nativeAdMedia.setNativeAd(this.facebookAd);
        this.facebookAd.unregisterView();
        this.facebookAd.registerViewForInteraction((View)this.view_root);
    }

    private void bindNativeAd(MyNativeAd myNativeAd) {
        String logoUrl = myNativeAd.getLogoUrl();
        ImageUtil.loadImage(this.ivLogo, logoUrl);
        String name = myNativeAd.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = this.app_name + " \uad11\uace0";
        }
        this.tvName.setText((CharSequence)name);
        String imageUrl = myNativeAd.getImageUrl();
        ImageUtil.loadImage(this.ivImage, imageUrl);
        String body = myNativeAd.getBody();
        this.tvBody.setText((CharSequence)body);
        String etc = myNativeAd.getEtc();
        if (TextUtils.isEmpty((CharSequence)etc)) {
            this.tvEtc.setVisibility(8);
        } else {
            this.tvEtc.setVisibility(0);
            this.tvEtc.setText((CharSequence)etc);
        }
        String callToAction = myNativeAd.getCallToAction();
        if (TextUtils.isEmpty((CharSequence)callToAction)) {
            this.tvCallToAction.setVisibility(8);
        } else {
            this.tvCallToAction.setVisibility(0);
            this.tvCallToAction.setText((CharSequence)myNativeAd.getCallToAction());
        }
        this.view_root.setVisibility(0);
        this.view_container.setVisibility(0);
        this.container_admob_express.setVisibility(8);
        this.progressView.setVisibility(8);
    }

    class MyNativeAd {
        String logoUrl;
        String name;
        String imageUrl;
        String body;
        String callToAction;
        String etc;

        MyNativeAd() {
        }

        public String getLogoUrl() {
            return this.logoUrl;
        }

        public void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getCallToAction() {
            return this.callToAction;
        }

        public void setCallToAction(String callToAction) {
            this.callToAction = callToAction;
        }

        public String getEtc() {
            return this.etc;
        }

        public void setEtc(String etc) {
            this.etc = etc;
        }
    }
}

