/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.backpress;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import gun0912.tedadhelper.R;
import gun0912.tedadhelper.backpress.OnBackPressListener;
import gun0912.tedadhelper.nativead.OnNativeAdListener;
import gun0912.tedadhelper.nativead.TedNativeAdHolder;
import gun0912.tedadhelper.util.AppUtil;
import gun0912.tedadhelper.util.SharedPreferenceUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class TedBackPressDialog
extends AppCompatActivity {
    private static final String EXTRA_APP_NAME = "app_name";
    private static final String EXTRA_FACEBOOK_KEY = "facebook_key";
    private static final String EXTRA_ADMOB_KEY = "admob_key";
    private static final String EXTRA_AD_PRIORITY_LIST = "ad_priority_list";
    private static final String EXTRA_SHOW_REVIEW_BUTTON = "show_review_button";
    private static OnBackPressListener onBackPressListener;
    View adviewContainer;
    TextView tvFinish;
    TextView tvReview;
    View dividerBtn;
    String appName;
    String facebookKey;
    String admobKey;
    boolean showReviewButton;
    TedNativeAdHolder adViewNativeAdHolder;
    ArrayList<Integer> adPriorityList;

    public static void startFacebookDialog(Activity activity, String appName, String facebookKey, OnBackPressListener onBackPressListener) {
        TedBackPressDialog.startDialog(activity, appName, facebookKey, null, 1, onBackPressListener);
    }

    public static void startDialog(Activity activity, String appName, String facebookKey, String admobKey, int adPriority, OnBackPressListener onBackPressListener) {
        TedBackPressDialog.startDialog(activity, appName, facebookKey, admobKey, adPriority, true, onBackPressListener);
    }

    public static void startDialog(Activity activity, String appName, String facebookKey, String admobKey, int adPriority, boolean showReviewButton, OnBackPressListener onBackPressListener) {
        Integer[] tempAdPriorityList = new Integer[]{adPriority, adPriority == 1 ? Integer.valueOf(2) : Integer.valueOf(1)};
        TedBackPressDialog.startDialog(activity, appName, facebookKey, admobKey, tempAdPriorityList, showReviewButton, onBackPressListener);
    }

    public static void startDialog(Activity activity, String appName, String facebookKey, String admobKey, Integer[] adPriorityList, boolean showReviewButton, OnBackPressListener onBackPressListener) {
        Intent intent = new Intent((Context)activity, TedBackPressDialog.class);
        intent.putExtra(EXTRA_APP_NAME, appName);
        intent.putExtra(EXTRA_FACEBOOK_KEY, facebookKey);
        intent.putExtra(EXTRA_ADMOB_KEY, admobKey);
        intent.putExtra(EXTRA_SHOW_REVIEW_BUTTON, showReviewButton);
        intent.putExtra(EXTRA_AD_PRIORITY_LIST, new ArrayList<Integer>(Arrays.asList(adPriorityList)));
        if (onBackPressListener == null) {
            throw new RuntimeException("OnBackPressListener can not null");
        }
        TedBackPressDialog.onBackPressListener = onBackPressListener;
        activity.startActivity(intent);
        activity.overridePendingTransition(0, 0);
    }

    public static void startAdmobDialog(Activity activity, String appName, String admobKey, OnBackPressListener onBackPressListener) {
        TedBackPressDialog.startDialog(activity, appName, null, admobKey, 2, onBackPressListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        int width;
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        super.onCreate(savedInstanceState);
        this.setupFromSavedInstanceState(savedInstanceState);
        this.setContentView(R.layout.dialog_backpress);
        Display display = ((WindowManager)this.getSystemService("window")).getDefaultDisplay();
        this.getWindow().getAttributes().width = width = (int)((double)display.getWidth() * 0.9);
        this.setFinishOnTouchOutside(false);
        this.initView();
        this.showReviewButton();
        this.adViewNativeAdHolder = new TedNativeAdHolder(this.adviewContainer, (Context)this, this.appName, this.facebookKey, this.admobKey);
        this.adViewNativeAdHolder.loadAD(this.adPriorityList, new OnNativeAdListener(){

            @Override
            public void onError(String errorMessage) {
                if (onBackPressListener != null) {
                    onBackPressListener.onError(errorMessage);
                }
            }

            @Override
            public void onLoaded(int adType) {
                if (onBackPressListener != null) {
                    onBackPressListener.onLoaded(adType);
                }
            }

            @Override
            public void onAdClicked(int adType) {
                if (onBackPressListener != null) {
                    onBackPressListener.onAdClicked(adType);
                }
            }
        });
        this.checkReview();
    }

    private void showReviewButton() {
        if (!this.showReviewButton) {
            this.dividerBtn.setVisibility(8);
            this.tvReview.setVisibility(8);
        }
    }

    private void checkReview() {
        boolean isReview = SharedPreferenceUtil.getSharedPreference((Context)this, "review", false);
        if (isReview) {
            this.tvReview.setVisibility(8);
        }
    }

    private void setupFromSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.appName = savedInstanceState.getString(EXTRA_APP_NAME);
            this.facebookKey = savedInstanceState.getString(EXTRA_FACEBOOK_KEY);
            this.admobKey = savedInstanceState.getString(EXTRA_ADMOB_KEY);
            this.adPriorityList = savedInstanceState.getIntegerArrayList(EXTRA_AD_PRIORITY_LIST);
        } else {
            this.appName = this.getIntent().getStringExtra(EXTRA_APP_NAME);
            this.facebookKey = this.getIntent().getStringExtra(EXTRA_FACEBOOK_KEY);
            this.admobKey = this.getIntent().getStringExtra(EXTRA_ADMOB_KEY);
            this.adPriorityList = this.getIntent().getIntegerArrayListExtra(EXTRA_AD_PRIORITY_LIST);
        }
    }

    private void initView() {
        this.adviewContainer = this.findViewById(R.id.adview_container);
        this.dividerBtn = this.findViewById(R.id.divider_btn);
        this.tvReview = (TextView)this.findViewById(R.id.tv_review);
        this.tvReview.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TedBackPressDialog.this.onReviewClick();
            }
        });
        this.tvFinish = (TextView)this.findViewById(R.id.tv_finish);
        this.tvFinish.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TedBackPressDialog.this.onFinishClick();
            }
        });
    }

    private void onReviewClick() {
        AppUtil.openPlayStore((Context)this, this.getPackageName());
        SharedPreferenceUtil.putSharedPreference((Context)this, "review", true);
        if (onBackPressListener != null) {
            onBackPressListener.onReviewClick();
        }
    }

    private void onFinishClick() {
        this.finish();
        this.overridePendingTransition(0, 0);
        if (onBackPressListener != null) {
            onBackPressListener.onFinish();
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString(EXTRA_APP_NAME, this.appName);
        savedInstanceState.putString(EXTRA_FACEBOOK_KEY, this.facebookKey);
        savedInstanceState.putString(EXTRA_ADMOB_KEY, this.admobKey);
        savedInstanceState.putIntegerArrayList(EXTRA_AD_PRIORITY_LIST, this.adPriorityList);
    }

    public void onBackPressed() {
        this.finish();
        this.overridePendingTransition(0, 0);
    }

    protected void onDestroy() {
        if (this.adViewNativeAdHolder != null) {
            this.adViewNativeAdHolder.onDestroy();
        }
        super.onDestroy();
    }
}

