/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.mapdb.CC;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import shadow.net.jpountz.xxhash.XXHash32;

public class SerializerByteArray
implements GroupSerializer<byte[]> {
    private static final XXHash32 HASHER = CC.HASH_FACTORY.hash32();

    @Override
    public void serialize(DataOutput2 out, byte[] value) throws IOException {
        out.packInt(value.length);
        out.write(value);
    }

    @Override
    public byte[] deserialize(DataInput2 in, int available) throws IOException {
        int size2 = in.unpackInt();
        byte[] ret2 = new byte[size2];
        in.readFully(ret2);
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(byte[] a1, byte[] a2) {
        return Arrays.equals(a1, a2);
    }

    @Override
    public int hashCode(byte[] bytes, int seed) {
        return HASHER.hash(bytes, 0, bytes.length, seed);
    }

    @Override
    public int compare(byte[] o1, byte[] o2) {
        if (o1 == o2) {
            return 0;
        }
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            int b1 = o1[i] & 0xFF;
            int b2 = o2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return o1.length - o2.length;
    }

    @Override
    public int valueArraySearch(Object keys2, byte[] key) {
        return Arrays.binarySearch((byte[][])keys2, key, Serializer.BYTE_ARRAY);
    }

    @Override
    public int valueArraySearch(Object keys2, byte[] key, Comparator comparator) {
        Object[] v = this.valueArrayToArray(keys2);
        return Arrays.binarySearch(v, key, comparator);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        byte[][] vals2 = (byte[][])vals;
        out.packInt(vals2.length);
        for (byte[] b : vals2) {
            Serializer.BYTE_ARRAY.serialize(out, b);
        }
    }

    public byte[][] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        int s2 = in.unpackInt();
        byte[][] ret2 = new byte[s2][];
        for (int i = 0; i < s2; ++i) {
            ret2[i] = (byte[])Serializer.BYTE_ARRAY.deserialize(in, -1);
        }
        return ret2;
    }

    @Override
    public byte[] valueArrayGet(Object vals, int pos) {
        return ((byte[][])vals)[pos];
    }

    @Override
    public int valueArraySize(Object vals) {
        return ((byte[][])vals).length;
    }

    public byte[][] valueArrayEmpty() {
        return new byte[0][];
    }

    public byte[][] valueArrayPut(Object vals, int pos, byte[] newValue) {
        byte[][] array = (byte[][])vals;
        byte[][] ret2 = (byte[][])Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret2, pos + 1, array.length - pos);
        }
        ret2[pos] = newValue;
        return ret2;
    }

    public byte[][] valueArrayUpdateVal(Object vals, int pos, byte[] newValue) {
        byte[][] vals2 = (byte[][])vals;
        vals2 = (byte[][])vals2.clone();
        vals2[pos] = newValue;
        return vals2;
    }

    public byte[][] valueArrayFromArray(Object[] objects) {
        byte[][] ret2 = new byte[objects.length][];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = (byte[])objects[i];
        }
        return ret2;
    }

    public byte[][] valueArrayCopyOfRange(Object vals, int from, int to) {
        return (byte[][])Arrays.copyOfRange((byte[][])vals, from, to);
    }

    public byte[][] valueArrayDeleteValue(Object vals, int pos) {
        byte[][] vals2 = new byte[((byte[][])vals).length - 1][];
        System.arraycopy(vals, 0, vals2, 0, pos - 1);
        System.arraycopy(vals, pos, vals2, pos - 1, vals2.length - (pos - 1));
        return vals2;
    }

    @Override
    public byte[] nextValue(byte[] value) {
        value = (byte[])value.clone();
        int i = value.length - 1;
        while (true) {
            int b1;
            if ((b1 = value[i] & 0xFF) == 255) {
                if (i == 0) {
                    return null;
                }
            } else {
                value[i] = (byte)(b1 + 1 & 0xFF);
                return value;
            }
            value[i] = 0;
            --i;
        }
    }
}

