/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;

public final class ByteIteratorIterate {
    private ByteIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(ByteIterator iterator2, ByteProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableByteCollection> R select(ByteIterator iterator2, BytePredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            byte item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableByteCollection> R reject(ByteIterator iterator2, BytePredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            byte item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(ByteIterator iterator2, ByteToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            byte item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static byte detectIfNone(ByteIterator iterator2, BytePredicate predicate, byte ifNone) {
        while (iterator2.hasNext()) {
            byte item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(ByteIterator iterator2, BytePredicate predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static boolean anySatisfy(ByteIterator iterator2, BytePredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(ByteIterator iterator2, BytePredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(ByteIterator iterator2, BytePredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(ByteIterator iterator2, T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static long sum(ByteIterator iterator2) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += (long)iterator2.next();
        }
        return sum2;
    }

    public static byte max(ByteIterator iterator2) {
        byte max2 = iterator2.next();
        while (iterator2.hasNext()) {
            byte next = iterator2.next();
            if (max2 >= next) continue;
            max2 = next;
        }
        return max2;
    }

    public static byte min(ByteIterator iterator2) {
        byte min2 = iterator2.next();
        while (iterator2.hasNext()) {
            byte next = iterator2.next();
            if (next >= min2) continue;
            min2 = next;
        }
        return min2;
    }
}

