/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectLongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectLongMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectLongHashMap<K>
implements MutableObjectLongMap<K>,
Externalizable {
    public static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectLongHashMap.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectLongHashMap.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;

    public ObjectLongHashMap() {
        this.allocateTable(16);
    }

    public ObjectLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectLongHashMap(ObjectLongMap<? extends K> map2) {
        this(Math.max(map2.size(), 8));
        this.putAll(map2);
    }

    public static <K> ObjectLongHashMap<K> newMap() {
        return new ObjectLongHashMap<K>();
    }

    public static <K> ObjectLongHashMap<K> newWithKeysValues(K key1, long value1) {
        return new ObjectLongHashMap<K>(1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectLongHashMap<K> newWithKeysValues(K key1, long value1, K key2, long value2) {
        return new ObjectLongHashMap<K>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectLongHashMap<K> newWithKeysValues(K key1, long value1, K key2, long value2, K key3, long value3) {
        return new ObjectLongHashMap<K>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectLongHashMap<K> newWithKeysValues(K key1, long value1, K key2, long value2, K key3, long value3, K key4, long value4) {
        return new ObjectLongHashMap<K>(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectLongMap)) {
            return false;
        }
        ObjectLongMap other = (ObjectLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += (this.toNonSentinel(this.keys[i]) == null ? 0 : this.keys[i].hashCode()) ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectLongHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectLongHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableLongIterator longIterator() {
        return new InternalLongIterator();
    }

    @Override
    public long[] toArray() {
        long[] result = new long[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public boolean contains(long value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, 0L);
    }

    @Override
    public void put(K key, long value) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectLongMap<? extends K> map2) {
        map2.forEachKeyValue(this::put);
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    private void removeKeyAtIndex(K key, int index) {
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public long removeKeyIfAbsent(K key, long value) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            long oldValue = this.values[index];
            this.values[index] = 0L;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public long getIfAbsentPut(K key, long value) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public long getIfAbsentPut(K key, LongFunction0 function) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        long value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> long getIfAbsentPutWith(K key, LongFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        long value = function.longValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public long getIfAbsentPutWithKey(K key, LongFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        long value = function.longValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public long updateValue(K key, long initialValueIfAbsent, LongToLongFunction function) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        long value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, long value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectLongHashMap.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public long addToValue(K key, long toBeAdded) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    @Override
    public ObjectLongHashMap<K> withKeyValue(K key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectLongHashMap<K> withKeysValues(K key1, long value1, K key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectLongHashMap<K> withKeysValues(K key1, long value1, K key2, long value2, K key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectLongHashMap<K> withKeysValues(K key1, long value1, K key2, long value2, K key3, long value3, K key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectLongHashMap<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectLongHashMap<K> withoutAllKeys(Iterable<? extends K> keys2) {
        for (K key : keys2) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectLongMap<K> asUnmodifiable() {
        return new UnmodifiableObjectLongMap(this);
    }

    @Override
    public MutableObjectLongMap<K> asSynchronized() {
        return new SynchronizedObjectLongMap(this);
    }

    @Override
    public ImmutableObjectLongMap<K> toImmutable() {
        return ObjectLongMaps.immutable.withAll(this);
    }

    @Override
    public long get(Object key) {
        return this.getIfAbsent(key, 0L);
    }

    @Override
    public long getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public long getIfAbsent(Object key, long ifAbsent) {
        int index = this.probe(key);
        if (ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectLongHashMap.isNonSentinel(this.keys[index]) && ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(long value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(LongProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectLongProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectLongHashMap<K> select(ObjectLongPredicate<? super K> predicate) {
        ObjectLongHashMap<K> result = ObjectLongHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectLongHashMap<K> reject(ObjectLongPredicate<? super K> predicate) {
        ObjectLongHashMap<K> result = ObjectLongHashMap.newMap();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableLongCollection select(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableLongCollection reject(LongPredicate predicate) {
        LongArrayList result = new LongArrayList();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        FastList<V> result = FastList.newList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(LongPredicate predicate) {
        int count2 = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<LongIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableLongIterator iterator2 = this.longIterator();
            while (iterator2.hasNext()) {
                MutableLongBag batch = LongBags.mutable.empty();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    @Override
    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max2 = 0L;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max2 >= this.values[i]) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min2 = 0L;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        long max2 = 0L;
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || isMaxSet && max2 >= this.values[i]) continue;
            max2 = this.values[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        long min2 = 0L;
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableLongList toList() {
        LongArrayList result = new LongArrayList(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableLongSet toSet() {
        LongHashSet result = new LongHashSet(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableLongBag toBag() {
        LongHashBag result = new LongHashBag(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size2 << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size2; ++i) {
            this.put(in.readObject(), in.readLong());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectLongPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableLongObjectMap<K> flipUniqueValues() {
        MutableLongObjectMap result = LongObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max2 = this.maxOccupiedWithData();
        int newCapacity = Math.max(max2, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max2 >> 1) + (max2 >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectLongHashMap.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectLongHashMap.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectLongHashMap.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (ObjectLongHashMap.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        int h2 = element == null ? 0 : element.hashCode();
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        h2 ^= h2 >>> 7 ^ h2 >>> 4;
        return h2 & this.keys.length - 1;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectLongHashMap.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectLongHashMap x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$502(ObjectLongHashMap x0, long[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectLongPair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectLongPair<K>> procedure) {
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[i]), ObjectLongHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectLongPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[i]), ObjectLongHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectLongPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[i]), ObjectLongHashMap.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectLongPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectLongPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectLongPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys2 = ObjectLongHashMap.this.keys;
                while (!ObjectLongHashMap.isNonSentinel(keys2[this.position])) {
                    ++this.position;
                }
                ObjectLongPair<Object> result = PrimitiveTuples.pair(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[this.position]), ObjectLongHashMap.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectLongHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectLongHashMap.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectLongProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i])) continue;
                objectLongProcedure.value(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i])) continue;
                procedure.value(ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys2 = ObjectLongHashMap.this.keys;
                while (!ObjectLongHashMap.isNonSentinel(keys2[this.position])) {
                    ++this.position;
                }
                Object result = ObjectLongHashMap.this.toNonSentinel(ObjectLongHashMap.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectLongHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableLongCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectLongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectLongHashMap.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectLongHashMap.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                    Object key = ObjectLongHashMap.this.keys[i];
                    if (!ObjectLongHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectLongHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(long item) {
            int oldSize = ObjectLongHashMap.this.size();
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                if (!ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[i]) || item != ObjectLongHashMap.this.values[i]) continue;
                ObjectLongHashMap.this.removeKey(ObjectLongHashMap.this.keys[i]);
            }
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public boolean removeAll(LongIterable source) {
            int oldSize = ObjectLongHashMap.this.size();
            LongIterator iterator2 = source.longIterator();
            while (iterator2.hasNext()) {
                this.remove(iterator2.next());
            }
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public boolean removeAll(long ... source) {
            int oldSize = ObjectLongHashMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public boolean retainAll(LongIterable source) {
            int oldSize = ObjectLongHashMap.this.size();
            LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            MutableObjectLongMap retained = ObjectLongHashMap.this.select((T object, long value) -> sourceSet.contains(value));
            if (((ObjectLongHashMap)retained).size() != oldSize) {
                ObjectLongHashMap.access$302(ObjectLongHashMap.this, ((ObjectLongHashMap)retained).keys);
                ObjectLongHashMap.access$502(ObjectLongHashMap.this, ((ObjectLongHashMap)retained).values);
                ObjectLongHashMap.this.occupiedWithData = ((ObjectLongHashMap)retained).occupiedWithData;
                ObjectLongHashMap.this.occupiedWithSentinels = ((ObjectLongHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(long ... source) {
            return this.retainAll(LongHashSet.newSetWith(source));
        }

        @Override
        public void clear() {
            ObjectLongHashMap.this.clear();
        }

        @Override
        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        @Override
        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        @Override
        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll(this);
        }

        @Override
        public MutableLongIterator longIterator() {
            return ObjectLongHashMap.this.longIterator();
        }

        @Override
        public long[] toArray() {
            return ObjectLongHashMap.this.toArray();
        }

        @Override
        public boolean contains(long value) {
            return ObjectLongHashMap.this.containsValue(value);
        }

        @Override
        public boolean containsAll(long ... source) {
            return ObjectLongHashMap.this.containsAll(source);
        }

        @Override
        public boolean containsAll(LongIterable source) {
            return ObjectLongHashMap.this.containsAll(source);
        }

        @Override
        public void forEach(LongProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(LongProcedure procedure) {
            ObjectLongHashMap.this.forEach(procedure);
        }

        @Override
        public MutableLongCollection select(LongPredicate predicate) {
            return ObjectLongHashMap.this.select(predicate);
        }

        @Override
        public MutableLongCollection reject(LongPredicate predicate) {
            return ObjectLongHashMap.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return ObjectLongHashMap.this.collect((LongToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            return ObjectLongHashMap.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<LongIterable> chunk(int size2) {
            return ObjectLongHashMap.this.chunk(size2);
        }

        @Override
        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return ObjectLongHashMap.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(LongPredicate predicate) {
            return ObjectLongHashMap.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(LongPredicate predicate) {
            return ObjectLongHashMap.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(LongPredicate predicate) {
            return ObjectLongHashMap.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(LongPredicate predicate) {
            return ObjectLongHashMap.this.noneSatisfy(predicate);
        }

        @Override
        public MutableLongList toList() {
            return ObjectLongHashMap.this.toList();
        }

        @Override
        public MutableLongSet toSet() {
            return ObjectLongHashMap.this.toSet();
        }

        @Override
        public MutableLongBag toBag() {
            return ObjectLongHashMap.this.toBag();
        }

        @Override
        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter(this);
        }

        @Override
        public long[] toSortedArray() {
            return ObjectLongHashMap.this.toSortedArray();
        }

        @Override
        public MutableLongList toSortedList() {
            return ObjectLongHashMap.this.toSortedList();
        }

        @Override
        public long sum() {
            return ObjectLongHashMap.this.sum();
        }

        @Override
        public long max() {
            return ObjectLongHashMap.this.max();
        }

        @Override
        public long maxIfEmpty(long defaultValue) {
            return ObjectLongHashMap.this.maxIfEmpty(defaultValue);
        }

        @Override
        public long min() {
            return ObjectLongHashMap.this.min();
        }

        @Override
        public long minIfEmpty(long defaultValue) {
            return ObjectLongHashMap.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectLongHashMap.this.average();
        }

        @Override
        public double median() {
            return ObjectLongHashMap.this.median();
        }

        @Override
        public MutableLongCollection newEmpty() {
            return new LongHashBag();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectLongHashMap.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys2 = ObjectLongHashMap.this.keys;
            while (!ObjectLongHashMap.isNonSentinel(keys2[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectLongHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectLongHashMap.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectLongHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectLongHashMap.this.removeKeyAtIndex(ObjectLongHashMap.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectLongHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode2 = 0;
            Object[] table = ObjectLongHashMap.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectLongHashMap.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectLongHashMap.this.toNonSentinel(key);
                hashCode2 += nonSentinelKey == null ? 0 : nonSentinelKey.hashCode();
            }
            return hashCode2;
        }

        @Override
        public int size() {
            return ObjectLongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectLongHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectLongHashMap.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size2 = ObjectLongHashMap.this.size();
            Object[] result = new Object[size2];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size2 = ObjectLongHashMap.this.size();
            if (result.length < size2) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size2);
            }
            this.copyKeys(result);
            if (size2 < result.length) {
                result[size2] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectLongHashMap.this.size();
            ObjectLongHashMap.this.removeKey(key);
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectLongHashMap.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectLongHashMap.this.size();
            Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                Object next = iterator2.next();
                if (collection.contains(next)) continue;
                iterator2.remove();
            }
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectLongHashMap.this.size();
            for (Object object : collection) {
                ObjectLongHashMap.this.removeKey(object);
            }
            return oldSize != ObjectLongHashMap.this.size();
        }

        @Override
        public void clear() {
            ObjectLongHashMap.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count2 = 0;
            for (int i = 0; i < ObjectLongHashMap.this.keys.length; ++i) {
                Object key = ObjectLongHashMap.this.keys[i];
                if (!ObjectLongHashMap.isNonSentinel(key)) continue;
                result[count2++] = ObjectLongHashMap.this.keys[i];
            }
        }
    }

    private class InternalLongIterator
    implements MutableLongIterator {
        private int count;
        private int position;

        private InternalLongIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectLongHashMap.this.size();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys2 = ObjectLongHashMap.this.keys;
            while (!ObjectLongHashMap.isNonSentinel(keys2[this.position])) {
                ++this.position;
            }
            long result = ObjectLongHashMap.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectLongHashMap.isNonSentinel(ObjectLongHashMap.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectLongHashMap.this.remove(ObjectLongHashMap.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

