/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableIntSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

class ImmutableIntIntMapKeySet
extends AbstractImmutableIntSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private final int[] keysValues;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableIntIntMapKeySet(int[] keysValues, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keysValues = keysValues;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !ImmutableIntIntMapKeySet.isEmptyKey(key) && !ImmutableIntIntMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += this.keysValues[i];
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count2 = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0));
                ++count2;
            }
            if (this.containsOneKey) {
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(1));
            }
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(this.keysValues[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public boolean contains(int value) {
        if (value == 0) {
            return this.containsZeroKey;
        }
        if (value == 1) {
            return this.containsOneKey;
        }
        return this.keysValues[this.probe(value)] == value;
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0);
        }
        if (this.containsOneKey) {
            procedure.value(1);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                procedure.value(this.keysValues[i]);
            }
        }
    }

    @Override
    public ImmutableIntSet select(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.containsZeroKey && predicate.accept(0)) {
            result.add(0);
        }
        if (this.containsOneKey && predicate.accept(1)) {
            result.add(1);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableIntSet reject(IntPredicate predicate) {
        IntHashSet result = new IntHashSet();
        if (this.containsZeroKey && !predicate.accept(0)) {
            result.add(0);
        }
        if (this.containsOneKey && !predicate.accept(1)) {
            result.add(1);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1));
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                target.add(function.valueOf(this.keysValues[i]));
            }
        }
        return target.toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return 0;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return 1;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return this.keysValues[i];
        }
        return ifNone;
    }

    @Override
    public int count(IntPredicate predicate) {
        int count2 = 0;
        if (this.containsZeroKey && predicate.accept(0)) {
            ++count2;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            ++count2;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sum() {
        long nextSum;
        long adjustedValue;
        long result = 0L;
        long compensation = 0L;
        if (this.containsZeroKey) {
            adjustedValue = 0L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                long adjustedValue2 = (long)this.keysValues[i] - compensation;
                long nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max2 = 0;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max2 = 0;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max2 < 1)) {
            max2 = 1;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || isMaxSet && max2 >= this.keysValues[i]) continue;
            max2 = this.keysValues[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min2 = 0;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min2 = 0;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1 < min2)) {
            min2 = 1;
            isMinSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i]) || isMinSet && this.keysValues[i] >= min2) continue;
            min2 = this.keysValues[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableIntIntMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result = function.valueOf(result, this.keysValues[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableIntSetSerializationProxy(this);
    }

    int probe(int element) {
        int index = this.mask(element) << 1;
        int keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 2; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(int element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            int keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(int element, int removedIndex) {
        int nextIndex = SpreadFunctions.intSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.intSpreadTwo(element)) | 1;
        int keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(int element) {
        int code = SpreadFunctions.intSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(int element) {
        int code = SpreadFunctions.intSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalIntIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ImmutableIntIntMapKeySet.this.size();
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableIntIntMapKeySet.this.containsZeroKey) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableIntIntMapKeySet.this.containsOneKey) {
                    return 1;
                }
            }
            int[] keysValues = ImmutableIntIntMapKeySet.this.keysValues;
            while (!ImmutableIntIntMapKeySet.isNonSentinel(keysValues[this.position])) {
                this.position += 2;
            }
            int result = ImmutableIntIntMapKeySet.this.keysValues[this.position];
            this.position += 2;
            return result;
        }
    }
}

