/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bimap.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bimap.ImmutableBiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.AbstractSynchronizedMapIterable;
import org.eclipse.collections.impl.map.mutable.SynchronizedBiMapSerializationProxy;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public class SynchronizedBiMap<K, V>
extends AbstractSynchronizedMapIterable<K, V>
implements MutableBiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    protected SynchronizedBiMap(MutableBiMap<K, V> delegate) {
        super(delegate);
    }

    protected SynchronizedBiMap(MutableBiMap<K, V> delegate, Object lock) {
        super(delegate, lock);
    }

    public static <K, V> SynchronizedBiMap<K, V> of(MutableBiMap<K, V> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBiMap for null");
        }
        return new SynchronizedBiMap<K, V>(map2);
    }

    @Override
    protected MutableBiMap<K, V> getDelegate() {
        return (MutableBiMap)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V forcePut(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().forcePut(key, value);
        }
    }

    @Override
    public MutableBiMap<K, V> asSynchronized() {
        return this;
    }

    @Override
    public MutableBiMap<K, V> asUnmodifiable() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asUnmodifiable() not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> clone() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedBiMap.of(this.getDelegate().clone());
        }
    }

    @Override
    public MutableBiMap<K, V> tap(Procedure<? super V> procedure) {
        return (MutableBiMap)super.tap((Procedure)procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableBiMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collect((Function2)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> MutableBiMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectValues((Function2)function);
        }
    }

    @Override
    public MutableSet<V> select(Predicate<? super V> predicate) {
        return (MutableSet)super.select((Predicate)predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().select((Predicate2)predicate);
        }
    }

    @Override
    public <P> MutableSet<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableSet)super.selectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        return (MutableSet)super.selectInstancesOf((Class)clazz);
    }

    @Override
    public MutableSet<V> reject(Predicate<? super V> predicate) {
        return (MutableSet)super.reject((Predicate)predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().reject((Predicate2)predicate);
        }
    }

    @Override
    public <P> MutableSet<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (MutableSet)super.rejectWith((Predicate2)predicate, (Object)parameter);
    }

    @Override
    public PartitionMutableSet<V> partition(Predicate<? super V> predicate) {
        return (PartitionMutableSet)super.partition((Predicate)predicate);
    }

    @Override
    public <P> PartitionMutableSet<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (PartitionMutableSet)super.partitionWith(predicate, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableSetMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupBy((Function)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V1> MutableSetMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupByEach((Function)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSetMultimap<V, K> flip() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<V, K> inverse() {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedBiMap<K, V>(this.getDelegate().inverse(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<V, K> flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flipUniqueValues();
        }
    }

    @Override
    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    @Override
    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBiMap<K, V> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return (MutableSet)super.zipWithIndex();
    }

    @Override
    public <VV> MutableBiMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return (MutableBiMap)super.groupByUniqueKey((Function)function);
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<V, S>> zip(Iterable<S> that) {
        return (MutableSet)super.zip((Iterable)that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> withKeyValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().put(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        Object object = this.lock;
        synchronized (object) {
            for (Pair<K, V> keyValue : keyValues) {
                this.getDelegate().put(keyValue.getOne(), keyValue.getTwo());
            }
            return this;
        }
    }

    @Override
    public MutableBiMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        return this.withAllKeyValues(ArrayAdapter.adapt(keyValuePairs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> withoutKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().remove(key);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBiMap<K, V> withoutAllKeys(Iterable<? extends K> keys2) {
        Object object = this.lock;
        synchronized (object) {
            for (K key : keys2) {
                this.getDelegate().removeKey(key);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableCollection.of(this.getDelegate().values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().entrySet(), this.lock);
        }
    }

    protected Object writeReplace() {
        return new SynchronizedBiMapSerializationProxy(this.getDelegate());
    }
}

