/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.audit;

import java.util.Objects;

public class Proxy {
    private String scheme;
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String[] nonProxyHosts;

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == null) {
            switch (this.scheme) {
                case "http": {
                    return 80;
                }
                case "https": {
                    return 443;
                }
            }
            throw new IllegalArgumentException("Unknown proxy scheme: " + this.scheme);
        }
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        if (nonProxyHosts != null) {
            this.nonProxyHosts = nonProxyHosts.split("|");
        }
    }

    public boolean isValid() {
        if (this.host == null) {
            return false;
        }
        if (this.nonProxyHosts != null) {
            for (String nonProxyHost : this.nonProxyHosts) {
                if (!this.host.equals(nonProxyHost)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.user + "@" + this.host + ":" + this.getPort();
    }

    public boolean equals(Object o) {
        if (o instanceof Proxy) {
            Proxy p = (Proxy)o;
            return Objects.equals(this.scheme, p.scheme) && Objects.equals(this.host, p.host) && Objects.equals(this.port, p.port) && Objects.equals(this.user, p.user) && Objects.equals(this.password, p.password) && Objects.equals(this.nonProxyHosts, p.nonProxyHosts);
        }
        return false;
    }
}

