/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.audit;

import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import net.ossindex.common.OssiPackage;
import net.ossindex.common.OssiVulnerability;
import net.ossindex.gradle.audit.MavenIdWrapper;
import org.gradle.internal.impldep.com.google.gson.annotations.SerializedName;

public class MavenPackageDescriptor
extends MavenIdWrapper {
    private MavenIdWrapper parent;
    @XmlElement(name="unfiltered-vulnerability-count")
    @SerializedName(value="unfiltered-vulnerability-count")
    private int unfilteredVulnerabilityCount;
    @XmlElement(name="vulnerability-matches")
    @SerializedName(value="vulnerability-matches")
    private int vulnerabilityMatches;
    @XmlElementWrapper(name="vulnerabilities")
    @XmlElement(name="vulnerability")
    private List<OssiVulnerability> vulnerabilities;

    public MavenPackageDescriptor() {
    }

    public MavenPackageDescriptor(OssiPackage pkg) {
        this.groupId = pkg.getNamespace();
        this.artifactId = pkg.getName();
        this.version = pkg.getVersion();
        this.vulnerabilities = pkg.getVulnerabilities();
        this.unfilteredVulnerabilityCount = pkg.getUnfilteredVulnerabilityMatches();
        this.vulnerabilityMatches = this.vulnerabilities.size();
    }

    public void setParent(MavenIdWrapper parent) {
        this.parent = parent;
    }

    public MavenIdWrapper getParent() {
        return this.parent;
    }

    public int getAllVulnerabilityCount() {
        return this.unfilteredVulnerabilityCount;
    }

    public int getVulnerabilityMatches() {
        return this.vulnerabilityMatches;
    }

    public List<OssiVulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.parent);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MavenPackageDescriptor other = (MavenPackageDescriptor)obj;
        return Objects.equals(this.parent, other.parent);
    }
}

