/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.audit;

import net.ossindex.common.OssiPackage;

public class MavenIdWrapper {
    protected String groupId;
    protected String artifactId;
    protected String version;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenIdWrapper that = (MavenIdWrapper)o;
        return this.getMavenVersionId() != null ? this.getMavenVersionId().equals(that.getMavenVersionId()) : that.getMavenVersionId() == null;
    }

    public int hashCode() {
        return this.getMavenVersionId() != null ? this.getMavenVersionId().hashCode() : 0;
    }

    public MavenIdWrapper() {
    }

    public MavenIdWrapper(OssiPackage pkg) {
        this.setGroupId(pkg.getNamespace());
        this.setArtifactId(pkg.getName());
        this.setVersion(pkg.getVersion());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMavenPackageId() {
        StringBuilder sb = new StringBuilder();
        if (this.groupId != null) {
            sb.append(this.groupId);
        }
        sb.append(":");
        if (this.artifactId != null) {
            sb.append(this.artifactId);
        }
        return sb.toString();
    }

    public String getMavenVersionId() {
        StringBuilder sb = new StringBuilder();
        if (this.groupId != null) {
            sb.append(this.groupId);
        }
        sb.append(":");
        if (this.artifactId != null) {
            sb.append(this.artifactId);
        }
        sb.append(":");
        if (this.version != null) {
            sb.append(this.version);
        }
        return sb.toString();
    }
}

