/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import java.util.List;
import net.ossindex.common.OssiVulnerability;
import org.sonatype.goodies.packageurl.PackageUrl;

public class OssiPackage {
    private String coordinates;
    private String description;
    private String reference;
    private int unfilteredVulnerabilityMatches;
    private List<OssiVulnerability> vulnerabilities;
    private transient PackageUrl purl;

    public OssiPackage(String type, String namespace, String artifactId, String version) {
        this.coordinates = namespace == null || namespace.isEmpty() ? "pkg:" + type + "/" + artifactId + "@" + version : "pkg:" + type + "/" + namespace + "/" + artifactId + "@" + version;
    }

    private OssiPackage(Builder builder) {
        this.coordinates = builder.coordinates;
        this.description = builder.description;
        this.reference = builder.reference;
        this.unfilteredVulnerabilityMatches = builder.unfilteredVulnerabilityMatches;
        this.vulnerabilities = builder.vulnerabilities;
        this.purl = builder.purl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OssiPackage copy) {
        Builder builder = new Builder();
        builder.coordinates = copy.coordinates;
        builder.description = copy.description;
        builder.reference = copy.reference;
        builder.unfilteredVulnerabilityMatches = copy.unfilteredVulnerabilityMatches;
        builder.vulnerabilities = copy.vulnerabilities;
        builder.purl = copy.purl;
        return builder;
    }

    public String getCoordinates() {
        return this.coordinates;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public List<OssiVulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public int getUnfilteredVulnerabilityMatches() {
        return this.unfilteredVulnerabilityMatches;
    }

    public PackageUrl getPurl() {
        return this.purl;
    }

    public String getType() {
        if (this.purl == null) {
            this.purl = PackageUrl.parse((String)this.coordinates);
        }
        return this.purl.getType();
    }

    public String getNamespace() {
        if (this.purl == null) {
            this.purl = PackageUrl.parse((String)this.coordinates);
        }
        return this.purl.getNamespaceAsString();
    }

    public String getName() {
        if (this.purl == null) {
            this.purl = PackageUrl.parse((String)this.coordinates);
        }
        return this.purl.getName();
    }

    public String getVersion() {
        if (this.purl == null) {
            this.purl = PackageUrl.parse((String)this.coordinates);
        }
        return this.purl.getVersion();
    }

    public static final class Builder {
        private String coordinates;
        private String description;
        private String reference;
        private int unfilteredVulnerabilityMatches;
        private List<OssiVulnerability> vulnerabilities;
        private PackageUrl purl;

        private Builder() {
        }

        public Builder withCoordinates(String val) {
            this.coordinates = val;
            return this;
        }

        public Builder withDescription(String val) {
            this.description = val;
            return this;
        }

        public Builder withReference(String val) {
            this.reference = val;
            return this;
        }

        public Builder withUnfilteredVulnerabilityMatches(int val) {
            this.unfilteredVulnerabilityMatches = val;
            return this;
        }

        public Builder withVulnerabilities(List<OssiVulnerability> val) {
            this.vulnerabilities = val;
            return this;
        }

        public Builder withPurl(PackageUrl val) {
            this.purl = val;
            return this;
        }

        public OssiPackage build() {
            return new OssiPackage(this);
        }
    }
}

