package net.ossindex.common.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.ossindex.common.PackageCoordinate;

class VulnerabilityFilterImpl implements IVulnerabilityFilter
{
  private Map<PackageCoordinate, List<Set<PackageCoordinate>>> filteredPackages = new HashMap<>();

  private Map<String, List<Set<PackageCoordinate>>> filteredIssues = new HashMap<>();

  @Override
  public void ignorePackage(final List<PackageCoordinate> pkgs) {
    if (pkgs != null && !pkgs.isEmpty()) {
      PackageCoordinate pkg = pkgs.get(pkgs.size() - 1);

      List<Set<PackageCoordinate>> sets = null;
      if (!filteredPackages.containsKey(pkg)) {
        sets = new LinkedList<>();
        filteredPackages.put(pkg, sets);
      }
      else {
        sets = filteredPackages.get(pkg);
      }
      Set<PackageCoordinate> set = new HashSet<>();
      set.addAll(pkgs);
      sets.add(set);
    }
  }

  @Override
  public void ignoreVulnerability(final String vid) {
    ignoreVulnerability(null, vid);
  }

  @Override
  public void ignoreVulnerability(final List<PackageCoordinate> pkgs, final String vid) {
    if (vid == null) {
      ignorePackage(pkgs);
    }
    List<Set<PackageCoordinate>> sets = null;
    if (!filteredIssues.containsKey(vid)) {
      sets = new LinkedList<>();
      filteredIssues.put(vid, sets);
    } else {
      sets = filteredIssues.get(vid);
    }
    if (pkgs != null) {
      Set<PackageCoordinate> set = new HashSet<>();
      set.addAll(pkgs);
      sets.add(set);
    } else {
      sets.add(Collections.EMPTY_SET);
    }
  }

  /**
   * @return true if the specified vulnerability should be filtered.
   */
  boolean shouldFilter(final List<PackageCoordinate> path, final String vid) {
    Set<PackageCoordinate> pkgSet = new HashSet<>();
    if (path != null) {
      pkgSet.addAll(path);
    }

    // Is the package outright filtered?
    if (path != null && !path.isEmpty()) {
      PackageCoordinate pkg = path.get(path.size() - 1);
      if (filteredPackages.containsKey(pkg)) {
        List<Set<PackageCoordinate>> sets = filteredPackages.get(pkg);
        for (Set<PackageCoordinate> set: sets) {
          if (set.isEmpty() || pkgSet.containsAll(set)) {
            return true;
          }
        }
      }
    }

    if (vid != null) {
      if (filteredIssues.containsKey(vid)) {
        List<Set<PackageCoordinate>> sets = filteredIssues.get(vid);
        for (Set<PackageCoordinate> set : sets) {
          // We either need to match an empty list (indicating a simple issue match), or we need all packages to match
          if (set.isEmpty() || pkgSet.containsAll(set)) {
            return true;
          }
        }
      }
    }
    return false;
  }

}
