package net.ossindex.common.filter;

import java.util.List;
import java.util.Set;

import net.ossindex.common.PackageCoordinate;

public interface IVulnerabilityFilter
{
  /**
   * Ignore all vulnerabilities belonging to a specific package
   */
  public void ignorePackage(final List<PackageCoordinate> pkgs);

  /**
   * Ignore a specific vulnerability
   */
  public void ignoreVulnerability(final String vid);

  /**
   * Ignore a specific vulnerability which is included in a dependency path including ALL of the specified coordinates.
   * This can be used in may ways:
   *
   *   1. Broadly specify a vulnerability being included by a specific "introducing" package
   *   2. Specify a vulnerability being included by a specific "vulnerable" package, since the same vulnerability might
   *      be assigned to multiple packages and we only want to filter it through one of the inclusions
   *   3. Specify a vulnerability which is included through a specific path, for example a specified including
   *      package and the specific vulnerable package.
   */
  public void ignoreVulnerability(final List<PackageCoordinate> pkg, final String vid);
}
