/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.generate_sources;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import name.remal.Java_io_FileKt;
import name.remal.gradle_plugins.dsl.BuildTask;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_TaskKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@BuildTask
@CacheableTask
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00042!\u0010 \u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130\u0011H\u0004J\b\u0010$\u001a\u00020\u0013H\u0005R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0014X\u0095\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u00128\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lname/remal/gradle_plugins/plugins/generate_sources/BaseGenerateTask;", "Lorg/gradle/api/internal/ConventionTask;", "()V", "charset", "", "getCharset", "()Ljava/lang/String;", "setCharset", "(Ljava/lang/String;)V", "classpath", "Lorg/gradle/api/file/FileCollection;", "getClasspath", "()Lorg/gradle/api/file/FileCollection;", "setClasspath", "(Lorg/gradle/api/file/FileCollection;)V", "generateActions", "", "Lkotlin/Function1;", "Ljava/io/File;", "", "objectsToCacheBy", "", "", "getObjectsToCacheBy", "()Ljava/util/Set;", "outputDir", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "addGenerateAction", "relativePath", "generateAction", "Lkotlin/ParameterName;", "name", "file", "executeGenerateActions", "gradle-plugins"})
public abstract class BaseGenerateTask
extends ConventionTask {
    @Input
    @NotNull
    private String charset;
    @Classpath
    @NotNull
    private FileCollection classpath;
    @OutputDirectory
    @NotNull
    public File outputDir;
    private final Map<String, Function1<File, Unit>> generateActions;
    @Input
    @NotNull
    private final Set<Object> objectsToCacheBy;

    @NotNull
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.charset = string;
    }

    @NotNull
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.classpath = fileCollection;
    }

    @NotNull
    public File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    public void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @TaskAction
    protected final void executeGenerateActions() {
        Java_io_FileKt.forceDeleteRecursively((File)this.getOutputDir());
        this.generateActions.forEach((BiConsumer<String, Function1<File, Unit>>)new BiConsumer<String, Function1<? super File, ? extends Unit>>(this){
            final /* synthetic */ BaseGenerateTask this$0;

            public final void accept(@NotNull String relativePath, @NotNull Function1<? super File, Unit> generateAction) {
                File targetFile;
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                Intrinsics.checkParameterIsNotNull(generateAction, (String)"generateAction");
                File file = targetFile = new File(this.this$0.getOutputDir(), relativePath).getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"targetFile");
                Java_io_FileKt.createParentDirectories((File)file);
                generateAction.invoke((Object)targetFile);
            }
            {
                this.this$0 = baseGenerateTask;
            }
        });
        this.setDidWork(true);
    }

    protected final void addGenerateAction(@NotNull String relativePath, @NotNull Function1<? super File, Unit> generateAction) {
        Map<String, Function1<File, Unit>> map;
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull(generateAction, (String)"generateAction");
        Map<String, Function1<File, Unit>> map2 = map = this.generateActions;
        if (map2.containsKey(relativePath)) {
            this.getLogger().warn("Redefining generation of {}", (Object)relativePath);
        }
        map = this.generateActions;
        map2 = generateAction;
        map.put(relativePath, (Function1<File, Unit>)map2);
    }

    @NotNull
    protected Set<Object> getObjectsToCacheBy() {
        return this.objectsToCacheBy;
    }

    public BaseGenerateTask() {
        Set set;
        Set set2;
        String string = StandardCharsets.UTF_8.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UTF_8.name()");
        this.charset = string;
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files()");
        this.classpath = (FileCollection)configurableFileCollection;
        this.generateActions = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        Org_gradle_api_TaskKt.noSourceIf((Task)this, (Function1)((Function1)new Function1<BaseGenerateTask, Boolean>(){

            public final boolean invoke(@NotNull BaseGenerateTask it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return generateActions.isEmpty();
            }
        }));
        BaseGenerateTask baseGenerateTask = this;
        Set $receiver = set2 = (set = (Set)new LinkedHashSet());
        $receiver.add(this.generateActions.keySet());
        baseGenerateTask.objectsToCacheBy = set = set2;
    }
}

