/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.classes_processing;

import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import name.remal.ServicesKt;
import name.remal.gradle_plugins.dsl.ApplyPluginClasses;
import name.remal.gradle_plugins.dsl.BaseReflectiveProjectPlugin;
import name.remal.gradle_plugins.dsl.Plugin;
import name.remal.gradle_plugins.dsl.PluginAction;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_DomainObjectCollectionKt;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingFilter;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingFiltersFactory;
import name.remal.gradle_plugins.plugins.classes_processing.ClassesProcessingPlugin;
import name.remal.gradle_plugins.plugins.common.CommonSettingsPlugin;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Plugin(id="name.remal.classes-processing", description="Plugin that adds ability to process *.class files. It executes all ClassesProcessor services for each compiled class file.", tags={"java"})
@ApplyPluginClasses(value={CommonSettingsPlugin.class})
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0004\b\t\n\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin;", "Lname/remal/gradle_plugins/dsl/BaseReflectiveProjectPlugin;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "(Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "setupClassesProcessing", "", "Lorg/gradle/api/tasks/TaskContainer;", "BinaryContent", "ClassFileInfo", "Companion", "Timing", "gradle-plugins"})
public class ClassesProcessingPlugin
extends BaseReflectiveProjectPlugin {
    private final FileSystem fileSystem;
    private static final List<ClassesProcessingFilter> classesProcessingFilters;
    private static final List<ClassesProcessingFiltersFactory> classesProcessingFiltersFactories;
    public static final Companion Companion;

    @PluginAction(isHidden=true)
    public void setupClassesProcessing(@NotNull TaskContainer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Org_gradle_api_DomainObjectCollectionKt.all((DomainObjectCollection)((DomainObjectCollection)$receiver), AbstractCompile.class, (Function1)setupClassesProcessing.1.INSTANCE);
    }

    @Inject
    public ClassesProcessingPlugin(@NotNull FileSystem fileSystem) {
        Intrinsics.checkParameterIsNotNull((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    static {
        Companion = new Companion(null);
        classesProcessingFilters = ServicesKt.loadServicesList(ClassesProcessingFilter.class);
        classesProcessingFiltersFactories = ServicesKt.loadServicesList(ClassesProcessingFiltersFactory.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$ClassFileInfo;", "", "fileVisitDetails", "Lorg/gradle/api/file/FileVisitDetails;", "(Lorg/gradle/api/file/FileVisitDetails;)V", "relativePath", "Lorg/gradle/api/file/RelativePath;", "lastModified", "", "(Lorg/gradle/api/file/RelativePath;J)V", "getLastModified", "()J", "getRelativePath", "()Lorg/gradle/api/file/RelativePath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-plugins"})
    private static final class ClassFileInfo {
        @NotNull
        private final RelativePath relativePath;
        private final long lastModified;

        @NotNull
        public final RelativePath getRelativePath() {
            return this.relativePath;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public ClassFileInfo(@NotNull RelativePath relativePath, long lastModified) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            this.relativePath = relativePath;
            this.lastModified = lastModified;
        }

        public /* synthetic */ ClassFileInfo(RelativePath relativePath, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(relativePath, l);
        }

        public ClassFileInfo(@NotNull FileVisitDetails fileVisitDetails) {
            Intrinsics.checkParameterIsNotNull((Object)fileVisitDetails, (String)"fileVisitDetails");
            RelativePath relativePath = fileVisitDetails.getRelativePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"fileVisitDetails.relativePath");
            this(relativePath, fileVisitDetails.getLastModified());
        }

        @NotNull
        public final RelativePath component1() {
            return this.relativePath;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final ClassFileInfo copy(@NotNull RelativePath relativePath, long lastModified) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new ClassFileInfo(relativePath, lastModified);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClassFileInfo copy$default(ClassFileInfo classFileInfo, RelativePath relativePath, long l, int n, Object object) {
            if ((n & 1) != 0) {
                relativePath = classFileInfo.relativePath;
            }
            if ((n & 2) != 0) {
                l = classFileInfo.lastModified;
            }
            return classFileInfo.copy(relativePath, l);
        }

        public String toString() {
            return "ClassFileInfo(relativePath=" + this.relativePath + ", lastModified=" + this.lastModified + ")";
        }

        public int hashCode() {
            RelativePath relativePath = this.relativePath;
            return (relativePath != null ? relativePath.hashCode() : 0) * 31 + Long.hashCode(this.lastModified);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassFileInfo)) break block3;
                    ClassFileInfo classFileInfo = (ClassFileInfo)object;
                    if (!Intrinsics.areEqual((Object)this.relativePath, (Object)classFileInfo.relativePath) || !(this.lastModified == classFileInfo.lastModified)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$Timing;", "", "totalExecutionMillis", "", "executionsCount", "(JJ)V", "getExecutionsCount", "()J", "setExecutionsCount", "(J)V", "getTotalExecutionMillis", "setTotalExecutionMillis", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-plugins"})
    private static final class Timing {
        private long totalExecutionMillis;
        private long executionsCount;

        public final long getTotalExecutionMillis() {
            return this.totalExecutionMillis;
        }

        public final void setTotalExecutionMillis(long l) {
            this.totalExecutionMillis = l;
        }

        public final long getExecutionsCount() {
            return this.executionsCount;
        }

        public final void setExecutionsCount(long l) {
            this.executionsCount = l;
        }

        public Timing(long totalExecutionMillis, long executionsCount) {
            this.totalExecutionMillis = totalExecutionMillis;
            this.executionsCount = executionsCount;
        }

        public /* synthetic */ Timing(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            this(l, l2);
        }

        public Timing() {
            this(0L, 0L, 3, null);
        }

        public final long component1() {
            return this.totalExecutionMillis;
        }

        public final long component2() {
            return this.executionsCount;
        }

        @NotNull
        public final Timing copy(long totalExecutionMillis, long executionsCount) {
            return new Timing(totalExecutionMillis, executionsCount);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Timing copy$default(Timing timing, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = timing.totalExecutionMillis;
            }
            if ((n & 2) != 0) {
                l2 = timing.executionsCount;
            }
            return timing.copy(l, l2);
        }

        public String toString() {
            return "Timing(totalExecutionMillis=" + this.totalExecutionMillis + ", executionsCount=" + this.executionsCount + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.totalExecutionMillis) * 31 + Long.hashCode(this.executionsCount);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Timing)) break block3;
                    Timing timing = (Timing)object;
                    if (!(this.totalExecutionMillis == timing.totalExecutionMillis) || !(this.executionsCount == timing.executionsCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$BinaryContent;", "", "content", "", "([B)V", "getContent", "()[B", "gradle-plugins"})
    private static final class BinaryContent {
        @Nullable
        private final byte[] content;

        @Nullable
        public final byte[] getContent() {
            return this.content;
        }

        public BinaryContent(@Nullable byte[] content) {
            this.content = content;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingPlugin$Companion;", "", "()V", "classesProcessingFilters", "", "Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingFilter;", "getClassesProcessingFilters", "()Ljava/util/List;", "classesProcessingFiltersFactories", "Lname/remal/gradle_plugins/plugins/classes_processing/ClassesProcessingFiltersFactory;", "getClassesProcessingFiltersFactories", "gradle-plugins"})
    public static final class Companion {
        private final List<ClassesProcessingFilter> getClassesProcessingFilters() {
            return classesProcessingFilters;
        }

        private final List<ClassesProcessingFiltersFactory> getClassesProcessingFiltersFactories() {
            return classesProcessingFiltersFactories;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getClassesProcessingFilters$p(Companion $this) {
            return $this.getClassesProcessingFilters();
        }

        @NotNull
        public static final /* synthetic */ List access$getClassesProcessingFiltersFactories$p(Companion $this) {
            return $this.getClassesProcessingFiltersFactories();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

