/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.internal.configurers;

import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import name.remal.Services;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.DeserializationFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.MapperFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.Module;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectMapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationFeature;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.ModuleCondition;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.ObjectMapperConfigurer;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;
import name.remal.log.LogUtils;
import org.jetbrains.annotations.NotNull;

@RelocatedClass
public class DefaultObjectMapperConfigurer
implements ObjectMapperConfigurer {
    private static final List<ModuleCondition> MODULE_CONDITIONS = Services.loadServicesList(ModuleCondition.class);

    @Override
    public void configure(@NotNull ObjectMapper objectMapper) {
        objectMapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true);
        objectMapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, objectMapper.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS));
        this.loadModules(objectMapper);
    }

    private void loadModules(@NotNull ObjectMapper objectMapper) {
        Iterator modulesIterator = Services.loadServices(Module.class, (ClassLoader)this.getClass().getClassLoader()).iterator();
        while (true) {
            try {
                while (modulesIterator.hasNext()) {
                    Module module = (Module)modulesIterator.next();
                    boolean canBeRegistered = true;
                    for (ModuleCondition moduleCondition : MODULE_CONDITIONS) {
                        if (moduleCondition.canModuleBeRegistered(module)) continue;
                        canBeRegistered = false;
                        break;
                    }
                    if (!canBeRegistered) continue;
                    objectMapper.registerModule(module);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof LinkageError || throwable instanceof ClassNotFoundException || throwable instanceof ServiceConfigurationError) {
                    LogUtils.logDebug(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
                    continue;
                }
                LogUtils.logError(this.getClass(), (String)throwable.getMessage(), (Throwable)throwable);
                continue;
            }
            break;
        }
    }
}

