/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class InterruptionChecker {
    private static final long MAX_CHECK_FREQUENCY_NANOS = 100000000L;
    private long lastCheckTimeNanos = 0L;
    private final AtomicBoolean interrupted = new AtomicBoolean(false);
    private ExecutionException executionException;

    public void interrupt() {
        this.interrupted.set(true);
    }

    public boolean checkAndReturn() {
        long time = System.nanoTime();
        if (time - this.lastCheckTimeNanos > 100000000L) {
            this.lastCheckTimeNanos = time;
            if (Thread.currentThread().isInterrupted()) {
                this.interrupt();
            }
            return this.interrupted.get() || this.executionException != null;
        }
        return false;
    }

    public void check() throws InterruptedException, ExecutionException {
        if (this.checkAndReturn()) {
            if (this.executionException != null) {
                throw this.executionException;
            }
            throw new InterruptedException();
        }
    }

    public ExecutionException executionException(Exception e) {
        ExecutionException newExecutionException;
        this.executionException = newExecutionException = e instanceof ExecutionException ? (ExecutionException)e : new ExecutionException(e);
        return this.executionException;
    }
}

