/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.ReferenceTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class TypeParameter
extends HierarchicalTypeSignature {
    final String identifier;
    final ReferenceTypeSignature classBound;
    final List<ReferenceTypeSignature> interfaceBounds;

    public TypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds) {
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ReferenceTypeSignature getClassBound() {
        return this.classBound;
    }

    public List<ReferenceTypeSignature> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        if (this.classBound != null) {
            this.classBound.getAllReferencedClassNames(classNameListOut);
        }
        for (ReferenceTypeSignature typeSignature : this.interfaceBounds) {
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.identifier.hashCode() + (this.classBound == null ? 0 : this.classBound.hashCode() * 7) + this.interfaceBounds.hashCode() * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeParameter)) {
            return false;
        }
        TypeParameter o = (TypeParameter)obj;
        return o.identifier.equals(this.identifier) && (o.classBound == null && this.classBound == null || o.classBound != null && o.classBound.equals(this.classBound)) && o.interfaceBounds.equals(this.interfaceBounds);
    }

    public String toString() {
        String classBoundStr;
        StringBuilder buf = new StringBuilder();
        buf.append(this.identifier);
        if (this.classBound == null) {
            classBoundStr = null;
        } else {
            classBoundStr = this.classBound.toString();
            if (classBoundStr.equals("java.lang.Object")) {
                classBoundStr = null;
            }
        }
        if (classBoundStr != null || !this.interfaceBounds.isEmpty()) {
            buf.append(" extends");
        }
        if (classBoundStr != null) {
            buf.append(' ');
            buf.append(classBoundStr);
        }
        for (int i = 0; i < this.interfaceBounds.size(); ++i) {
            if (i > 0 || classBoundStr != null) {
                buf.append(" &");
            }
            buf.append(' ');
            buf.append(this.interfaceBounds.get(i).toString());
        }
        return buf.toString();
    }

    private static TypeParameter parse(TypeUtils.ParseState parseState) throws TypeUtils.ParseException {
        List<ReferenceTypeSignature> interfaceBounds;
        if (!parseState.parseIdentifier()) {
            throw new TypeUtils.ParseException();
        }
        String identifier = parseState.currToken();
        ReferenceTypeSignature classBound = ReferenceTypeSignature.parseClassBound(parseState);
        if (parseState.peek() == ':') {
            interfaceBounds = new ArrayList();
            while (parseState.peek() == ':') {
                parseState.expect(':');
                ReferenceTypeSignature interfaceTypeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
                if (interfaceTypeSignature == null) {
                    throw new TypeUtils.ParseException();
                }
                interfaceBounds.add(interfaceTypeSignature);
            }
        } else {
            interfaceBounds = Collections.emptyList();
        }
        return new TypeParameter(identifier, classBound, interfaceBounds);
    }

    static List<TypeParameter> parseList(TypeUtils.ParseState parseState) throws TypeUtils.ParseException {
        if (parseState.peek() != '<') {
            return Collections.emptyList();
        }
        parseState.expect('<');
        ArrayList<TypeParameter> typeParams = new ArrayList<TypeParameter>(1);
        while (parseState.peek() != '>') {
            if (!parseState.hasMore()) {
                throw new TypeUtils.ParseException();
            }
            typeParams.add(TypeParameter.parse(parseState));
        }
        parseState.expect('>');
        return typeParams;
    }
}

