/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderFinder;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ClasspathFinder {
    static final String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final List<RelativePath> rawClasspathElements;
    private final ClassLoader[] envClassLoaderOrder;

    private boolean addClassLoaderHandler(ScanSpec scanSpec, ClassLoader classLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries, AdditionOrderedSet<ClassLoader> foundClassLoaders, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, LogNode log) {
        ClassLoaderHandler classLoaderHandler;
        block11: {
            classLoaderHandler = null;
            try {
                classLoaderHandler = classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (log == null) break block11;
                log.log("Could not instantiate " + classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName(), e);
            }
        }
        if (classLoaderHandler != null) {
            if (log != null) {
                log.log("ClassLoader " + classLoader + " will be handled by " + classLoaderHandler);
            }
            ClassLoaderHandler.DelegationOrder delegationOrder = classLoaderHandler.getDelegationOrder(classLoader);
            ClassLoader parent = classLoader.getParent();
            if (log != null && parent != null) {
                log.log(classLoader + " delegates to parent " + parent + " with order " + (Object)((Object)delegationOrder));
            }
            switch (delegationOrder) {
                case PARENT_FIRST: {
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, allClassLoaderHandlerEntries, foundClassLoaders, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    return true;
                }
                case PARENT_LAST: {
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, allClassLoaderHandlerEntries, foundClassLoaders, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    return true;
                }
            }
            throw new RuntimeException("Unknown delegation order");
        }
        return false;
    }

    private void findClassLoaderHandlerForClassLoaderAndParents(ScanSpec scanSpec, ClassLoader classLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries, AdditionOrderedSet<ClassLoader> foundClassLoaders, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, LogNode log) {
        if (foundClassLoaders.add(classLoader)) {
            boolean foundMatch = false;
            for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                        if (!handledClassLoaderName.equals(c.getName())) continue;
                        if (!this.addClassLoaderHandler(scanSpec, classLoader, classLoaderHandlerRegistryEntry, allClassLoaderHandlerEntries, foundClassLoaders, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log)) break;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) continue;
                    break;
                }
                if (foundMatch) break;
            }
            if (!foundMatch) {
                if (log != null) {
                    log.log("Could not find a ClassLoaderHandler that can handle " + classLoader + " , trying " + ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER.classLoaderHandlerClass.getName() + " instead. Please report this at: https://github.com/lukehutch/fast-classpath-scanner/issues");
                }
                this.addClassLoaderHandler(scanSpec, classLoader, ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER, allClassLoaderHandlerEntries, foundClassLoaders, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
            }
        }
    }

    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        LogNode classpathFinderLog = log == null ? null : log.log("Finding ClassLoaders");
        this.envClassLoaderOrder = ClassLoaderFinder.findEnvClassLoaders(scanSpec, classpathFinderLog);
        ClasspathOrder classpathOrder = new ClasspathOrder(nestedJarHandler);
        ClasspathOrder ignoredClasspathOrder = new ClasspathOrder(nestedJarHandler);
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath with: " + scanSpec.overrideClasspath);
            classpathOrder.addClasspathElements(scanSpec.overrideClasspath, this.envClassLoaderOrder, overrideLog);
            if (overrideLog != null) {
                classpathFinderLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String[] stringArray;
            LogNode classLoaderClasspathLog;
            ClassLoaderHandler classLoaderHandler;
            List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries;
            if (!scanSpec.blacklistSystemJars()) {
                String rtJarPath = JarUtils.getRtJarPath();
                if (log != null) {
                    log.log(rtJarPath == null ? "Could not find path for rt.jar" : "Adding rt.jar as first classpath element to scan: " + rtJarPath);
                }
                if (rtJarPath != null) {
                    classpathOrder.addClasspathElement(rtJarPath, this.envClassLoaderOrder, classpathFinderLog);
                }
            }
            if (scanSpec.extraClassLoaderHandlers.isEmpty()) {
                allClassLoaderHandlerEntries = ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS;
            } else {
                allClassLoaderHandlerEntries = new ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(scanSpec.extraClassLoaderHandlers);
                allClassLoaderHandlerEntries.addAll(ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS);
            }
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    classLoaderHandlerLog.log(classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName());
                }
            }
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            for (ClassLoader envClassLoader : this.envClassLoaderOrder) {
                if (!scanSpec.blacklistSystemJars() || !envClassLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) {
                    this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, envClassLoader, allClassLoaderHandlerEntries, new AdditionOrderedSet<ClassLoader>(), classLoaderAndHandlerOrder, ignoredClassLoaderAndHandlerOrder, classpathFinderLog);
                    continue;
                }
                if (classpathFinderLog == null) continue;
                classpathFinderLog.log("Skipping system classloader " + envClassLoader.getClass().getName());
            }
            for (AbstractMap.SimpleEntry simpleEntry : classLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Finding classpath elements in ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, classpathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            for (AbstractMap.SimpleEntry simpleEntry : ignoredClassLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Will not scan the following classpath elements from ignored ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, ignoredClasspathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            if (scanSpec.overrideClassLoaders == null && scanSpec.overrideClasspath == null && (stringArray = JarUtils.smartPathSplit(System.getProperty("java.class.path"))).length > 0) {
                LogNode logNode = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                for (String pathElement : stringArray) {
                    if (!ignoredClasspathOrder.get().contains(new RelativePath(currDirPathStr, pathElement, this.envClassLoaderOrder, nestedJarHandler, log))) {
                        classpathOrder.addClasspathElement(pathElement, this.envClassLoaderOrder, logNode);
                        continue;
                    }
                    if (logNode == null) continue;
                    logNode.log("Found classpath element in java.class.path that will be ignored, since it is also found in an ignored parent classloader: " + pathElement);
                }
            }
        }
        this.rawClasspathElements = classpathOrder.get().toList();
    }

    public List<RelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    public ClassLoader[] getClassLoaderOrder() {
        return this.envClassLoaderOrder;
    }
}

