/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import java.io.File;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader"};
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classloader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager", false);
        Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries", false);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Object bundleFile = ReflectionUtils.invokeMethod(entries[i], "getBundleFile", false);
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile", false);
                if (baseFile == null) continue;
                classpathOrderOut.addClasspathElement(baseFile.getPath(), classloader, log);
            }
        }
    }
}

