/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Map;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.jboss.modules.ModuleClassLoader"};
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object module = ReflectionUtils.invokeMethod(classLoader, "getModule", false);
        Object serviceLoader = ReflectionUtils.invokeMethod(module, "getCallerModuleLoader", false);
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(serviceLoader, "moduleMap", false);
        for (Object key : moduleMap.keySet()) {
            Object futureModule = moduleMap.get(key);
            Object realModule = ReflectionUtils.invokeMethod(futureModule, "getModule", false);
            Object moduleLoader = ReflectionUtils.invokeMethod(realModule, "getClassLoader", false);
            Object vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders", false);
            if (vfsResourceLoaders == null) continue;
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                String path = null;
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                if (resourceLoader != null) {
                    Object root = ReflectionUtils.getFieldVal(resourceLoader, "root", false);
                    File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile", false);
                    if (physicalFile != null) {
                        File file;
                        String name = (String)ReflectionUtils.invokeMethod(root, "getName", false);
                        path = name != null ? (ClasspathUtils.canRead(file = new File(physicalFile.getParentFile(), name)) ? file.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
                    } else {
                        path = (String)ReflectionUtils.invokeMethod(root, "getPathName", false);
                        if (path == null) {
                            Object file = root instanceof Path ? ((Path)root).toFile() : root;
                            if (file == null) {
                                file = ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar", false);
                            }
                            path = (String)ReflectionUtils.invokeMethod(file, "getAbsolutePath", false);
                        }
                    }
                }
                classpathOrderOut.addClasspathElement(path, (ClassLoader)moduleLoader, log);
            }
        }
    }
}

