/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ViewMatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ViewMatcher EMPTY = new ViewMatcher();

    public boolean isVisibleForView(Class<?> activeView) {
        return false;
    }

    public static ViewMatcher construct(Class<?>[] views) {
        if (views == null) {
            return EMPTY;
        }
        switch (views.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new Single(views[0]);
            }
        }
        return new Multi(views);
    }

    @RelocatedClass
    private static final class Multi
    extends ViewMatcher
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?>[] _views;

        public Multi(Class<?>[] v) {
            this._views = v;
        }

        @Override
        public boolean isVisibleForView(Class<?> activeView) {
            for (Class<?> view : this._views) {
                if (activeView != view && !view.isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }
    }

    @RelocatedClass
    private static final class Single
    extends ViewMatcher {
        private static final long serialVersionUID = 1L;
        private final Class<?> _view;

        public Single(Class<?> v) {
            this._view = v;
        }

        @Override
        public boolean isVisibleForView(Class<?> activeView) {
            return activeView == this._view || this._view.isAssignableFrom(activeView);
        }
    }
}

