/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.RemoveExtensions;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusRemoveExtension
extends QuarkusPlatformTask {
    private List<String> extensionsToRemove;

    public QuarkusRemoveExtension() {
        super("Removes Quarkus extensions specified by the user to the project.");
    }

    @Option(option="extensions", description="Configures the extensions to be removed.")
    public void setExtensionsToRemove(List<String> extensionsToRemove) {
        this.extensionsToRemove = extensionsToRemove;
    }

    @Input
    public List<String> getExtensionsToRemove() {
        return this.extensionsToRemove;
    }

    @TaskAction
    public void removeExtension() {
        Set extensionsSet = this.getExtensionsToRemove().stream().flatMap(ext -> Arrays.stream(ext.split(","))).map(String::trim).collect(Collectors.toSet());
        try {
            new RemoveExtensions(this.getQuarkusProject()).extensions(extensionsSet).execute();
        }
        catch (Exception e) {
            throw new GradleException("Failed to remove extensions " + this.getExtensionsToRemove(), (Throwable)e);
        }
    }
}

