/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.gradle.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.utilities.JavaBinFinder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;

public class QuarkusDev
extends QuarkusTask {
    private Set<File> filesIncludedInClasspath = new HashSet<File>();
    private File buildDir;
    private String sourceDir;
    private String workingDir;
    private List<String> jvmArgs;
    private boolean preventnoverify = false;
    private List<String> args = new LinkedList<String>();
    private List<String> compilerArgs = new LinkedList<String>();

    @Inject
    public QuarkusDev() {
        super("Development mode: enables hot deployment with background compilation");
    }

    public QuarkusDev(String name) {
        super(name);
    }

    @InputDirectory
    @Optional
    public File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = this.getProject().getBuildDir();
        }
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    @Optional
    @InputDirectory
    public File getSourceDir() {
        if (this.sourceDir == null) {
            return this.extension().sourceDir();
        }
        return new File(this.sourceDir);
    }

    @Option(description="Set source directory", option="source-dir")
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Input
    public String getWorkingDir() {
        if (this.workingDir == null) {
            return this.extension().workingDir().toString();
        }
        return this.workingDir;
    }

    @Option(description="Set working directory", option="working-dir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Optional
    @Input
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    @Optional
    @Input
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Option(description="Set application arguments", option="quarkus-args")
    public void setArgsString(String argsString) {
        this.setArgs(Arrays.asList(Commandline.translateCommandline((String)argsString)));
    }

    @Input
    public boolean isPreventnoverify() {
        return this.preventnoverify;
    }

    @Option(description="value is intended to be set to true when some generated bytecode is erroneous causing the JVM to crash when the verify:none option is set (which is on by default)", option="prevent-noverify")
    public void setPreventnoverify(boolean preventnoverify) {
        this.preventnoverify = preventnoverify;
    }

    @Optional
    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Option(description="Additional parameters to pass to javac when recompiling changed source files", option="compiler-args")
    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    @TaskAction
    public void startDev() {
        Project project = this.getProject();
        QuarkusPluginExtension extension = (QuarkusPluginExtension)project.getExtensions().findByName("quarkus");
        if (!this.getSourceDir().isDirectory()) {
            throw new GradleException("The `src/main/java` directory is required, please create it.");
        }
        if (!this.extension().outputDirectory().isDirectory()) {
            throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
        }
        DevModeContext context = new DevModeContext();
        context.setProjectDir(project.getProjectDir());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            context.getSystemProperties().put(entry.getKey().toString(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : project.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            context.getBuildSystemProperties().put(entry.getKey(), entry.getValue().toString());
        }
        context.getBuildSystemProperties().putIfAbsent("quarkus.application.name", project.getName());
        if (project.getVersion() != null) {
            context.getBuildSystemProperties().putIfAbsent("quarkus.application.version", project.getVersion().toString());
        }
        context.setSourceEncoding(this.getSourceEncoding());
        try {
            AppModel appModel;
            ArrayList<String> args = new ArrayList<String>();
            args.add(JavaBinFinder.findBin());
            String string = System.getProperty("debug");
            String suspend = System.getProperty("suspend");
            String debugSuspend = "n";
            if (suspend != null) {
                switch (suspend.toLowerCase(Locale.ENGLISH)) {
                    case "n": 
                    case "false": {
                        debugSuspend = "n";
                        break;
                    }
                    case "": 
                    case "y": 
                    case "true": {
                        debugSuspend = "y";
                        break;
                    }
                    default: {
                        System.err.println("Ignoring invalid value \"" + suspend + "\" for \"suspend\" param and defaulting to \"n\"");
                    }
                }
            }
            if (string == null) {
                try (Socket socket = new Socket(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 5005);){
                    System.err.println("Port 5005 in use, not starting in debug mode");
                }
                catch (IOException e) {
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=0.0.0.0:5005,server=y,suspend=" + debugSuspend);
                }
            } else if (string.toLowerCase().equals("client")) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=localhost:5005,server=n,suspend=" + debugSuspend);
            } else if (string.toLowerCase().equals("true") || string.isEmpty()) {
                args.add("-Xdebug");
                args.add("-Xrunjdwp:transport=dt_socket,address=0.0.0.0:5005,server=y,suspend=" + debugSuspend);
            } else if (!string.toLowerCase().equals("false")) {
                try {
                    int port = Integer.parseInt(string);
                    if (port <= 0) {
                        throw new GradleException("The specified debug port must be greater than 0");
                    }
                    args.add("-Xdebug");
                    args.add("-Xrunjdwp:transport=dt_socket,address=0.0.0.0:" + port + ",server=y,suspend=" + debugSuspend);
                }
                catch (NumberFormatException e) {
                    throw new GradleException("Invalid value for debug parameter: " + string + " must be true|false|client|{port}");
                }
            }
            if (this.getJvmArgs() != null) {
                args.addAll(this.getJvmArgs());
            }
            args.add("-XX:TieredStopAtLevel=1");
            if (!this.isPreventnoverify()) {
                args.add("-Xverify:none");
            }
            StringBuilder classPathManifest = new StringBuilder();
            AppModelResolver modelResolver = this.extension().getAppModelResolver(LaunchMode.DEVELOPMENT);
            try {
                AppArtifact appArtifact = extension.getAppArtifact();
                appArtifact.setPaths(QuarkusGradleUtils.getOutputPaths(project));
                appModel = modelResolver.resolveModel(appArtifact);
            }
            catch (AppModelResolverException e) {
                throw new GradleException("Failed to resolve application model " + extension.getAppArtifact() + " dependencies", (Throwable)e);
            }
            args.add("-Djava.util.logging.manager=org.jboss.logmanager.LogManager");
            HashSet<AppArtifactKey> projectDependencies = new HashSet<AppArtifactKey>();
            this.addSelfWithLocalDeps(project, context, new HashSet<String>(), projectDependencies, true);
            for (AppDependency appDependency : appModel.getFullDeploymentDeps()) {
                AppArtifact appArtifact = appDependency.getArtifact();
                if (projectDependencies.contains(new AppArtifactKey(appArtifact.getGroupId(), appArtifact.getArtifactId()))) continue;
                appArtifact.getPaths().forEach(p -> {
                    if (Files.exists(p, new LinkOption[0])) {
                        this.addToClassPaths(classPathManifest, p.toFile());
                    }
                });
            }
            this.addGradlePluginDeps(classPathManifest, context);
            context.setCacheDir(new File(this.getBuildDir(), "transformer-cache").getAbsoluteFile());
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention != null) {
                context.setSourceJavaVersion(javaPluginConvention.getSourceCompatibility().toString());
                context.setTargetJvmVersion(javaPluginConvention.getTargetCompatibility().toString());
            }
            if (this.getCompilerArgs().isEmpty()) {
                this.getJavaCompileTask().map(compileTask -> compileTask.getOptions().getCompilerArgs()).ifPresent(arg_0 -> ((DevModeContext)context).setCompilerOptions(arg_0));
            } else {
                context.setCompilerOptions(this.getCompilerArgs());
            }
            File tempFile = new File(this.getBuildDir(), extension.finalName() + "-dev.jar");
            tempFile.delete();
            tempFile.deleteOnExit();
            context.setDevModeRunnerJarFile(tempFile);
            this.modifyDevModeContext(context);
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));){
                out.putNextEntry(new ZipEntry("META-INF/"));
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPathManifest.toString());
                manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, DevModeMain.class.getName());
                out.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(out);
                out.putNextEntry(new ZipEntry("META-INF/dev-mode-context.dat"));
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try (ObjectOutputStream obj = new ObjectOutputStream(new DataOutputStream(bytes));){
                    obj.writeObject(context);
                }
                out.write(bytes.toByteArray());
                out.putNextEntry(new ZipEntry("quarkus-internal.serialized-app-model.path"));
                bytes = new ByteArrayOutputStream();
                obj = new ObjectOutputStream(new DataOutputStream(bytes));
                var19_36 = null;
                try {
                    obj.writeObject(appModel);
                }
                catch (Throwable throwable) {
                    var19_36 = throwable;
                    throw throwable;
                }
                finally {
                    if (obj != null) {
                        if (var19_36 != null) {
                            try {
                                obj.close();
                            }
                            catch (Throwable throwable) {
                                var19_36.addSuppressed(throwable);
                            }
                        } else {
                            obj.close();
                        }
                    }
                }
                out.write(bytes.toByteArray());
            }
            Path serializedModel = QuarkusGradleUtils.serializeAppModel(appModel, (Task)this);
            serializedModel.toFile().deleteOnExit();
            args.add("-Dquarkus-internal.serialized-app-model.path=" + serializedModel.toAbsolutePath());
            extension.outputDirectory().mkdirs();
            if (context.isEnablePreview()) {
                args.add("--enable-preview");
            }
            args.add("-jar");
            args.add(tempFile.getAbsolutePath());
            args.addAll(this.getArgs());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Launching JVM with command line: {}", (Object)String.join((CharSequence)" ", args));
            }
            project.exec(action -> {
                action.commandLine((Iterable)args).workingDir((Object)this.getWorkingDir());
                action.setStandardInput(System.in).setErrorOutput((OutputStream)System.out).setStandardOutput((OutputStream)System.out);
            });
        }
        catch (Exception e) {
            throw new GradleException("Failed to run", (Throwable)e);
        }
    }

    protected void modifyDevModeContext(DevModeContext devModeContext) {
    }

    private void addSelfWithLocalDeps(Project project, DevModeContext context, Set<String> visited, Set<AppArtifactKey> addedDeps, boolean root) {
        if (!visited.add(project.getPath())) {
            return;
        }
        Configuration compileCp = (Configuration)project.getConfigurations().findByName("compileClasspath");
        if (compileCp != null) {
            compileCp.getIncoming().getDependencies().forEach(d -> {
                if (d instanceof ProjectDependency) {
                    this.addSelfWithLocalDeps(((ProjectDependency)d).getDependencyProject(), context, visited, addedDeps, false);
                }
            });
        }
        this.addLocalProject(project, context, addedDeps, root);
    }

    private void addLocalProject(Project project, DevModeContext context, Set<AppArtifactKey> addeDeps, boolean root) {
        String resourcesOutputPath;
        AppArtifactKey key = new AppArtifactKey(project.getGroup().toString(), project.getName());
        if (addeDeps.contains(key)) {
            return;
        }
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            return;
        }
        SourceSetContainer sourceSets = javaConvention.getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.findByName("main");
        if (mainSourceSet == null) {
            return;
        }
        HashSet<String> sourcePaths = new HashSet<String>();
        HashSet<String> sourceParentPaths = new HashSet<String>();
        for (File sourceDir : mainSourceSet.getAllJava().getSrcDirs()) {
            if (!sourceDir.exists()) continue;
            sourcePaths.add(sourceDir.getAbsolutePath());
            sourceParentPaths.add(sourceDir.toPath().getParent().toAbsolutePath().toString());
        }
        File resourcesSrcDir = mainSourceSet.getResources().getSourceDirectories().getSingleFile();
        if (sourcePaths.isEmpty() && !resourcesSrcDir.exists()) {
            return;
        }
        String classesDir = QuarkusGradleUtils.getClassesDir(mainSourceSet, project.getBuildDir());
        if (resourcesSrcDir.exists()) {
            resourcesOutputPath = mainSourceSet.getOutput().getResourcesDir().getAbsolutePath();
            if (!Files.exists(Paths.get(classesDir, new String[0]), new LinkOption[0])) {
                classesDir = resourcesOutputPath;
            }
        } else {
            resourcesOutputPath = classesDir;
        }
        DevModeContext.ModuleInfo wsModuleInfo = new DevModeContext.ModuleInfo(key, project.getName(), project.getProjectDir().getAbsolutePath(), sourcePaths, classesDir, resourcesSrcDir.getAbsolutePath(), resourcesOutputPath, sourceParentPaths, project.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString(), project.getBuildDir().toString());
        if (root) {
            context.setApplicationRoot(wsModuleInfo);
        } else {
            context.getAdditionalModules().add(wsModuleInfo);
        }
        addeDeps.add(key);
    }

    private String getSourceEncoding() {
        return this.getJavaCompileTask().map(javaCompile -> javaCompile.getOptions().getEncoding()).orElse(null);
    }

    private java.util.Optional<JavaCompile> getJavaCompileTask() {
        return java.util.Optional.ofNullable((JavaCompile)this.getProject().getTasks().getByName("compileJava"));
    }

    private ResolvedDependency findQuarkusPluginDependency(Set<ResolvedDependency> dependencies) {
        for (ResolvedDependency rd : dependencies) {
            ResolvedDependency quarkusPluginDependency;
            if ("io.quarkus.gradle.plugin".equals(rd.getModuleName())) {
                return rd;
            }
            Set children = rd.getChildren();
            if (children == null || (quarkusPluginDependency = this.findQuarkusPluginDependency(children)) == null) continue;
            return quarkusPluginDependency;
        }
        return null;
    }

    private void addGradlePluginDeps(StringBuilder classPathManifest, DevModeContext context) {
        boolean foundQuarkusPlugin = false;
        for (Project prj = this.getProject(); prj != null && !foundQuarkusPlugin; prj = prj.getParent()) {
            ResolvedDependency quarkusPluginDependency;
            Set firstLevelDeps = prj.getBuildscript().getConfigurations().getByName("classpath").getResolvedConfiguration().getFirstLevelModuleDependencies();
            if (firstLevelDeps.isEmpty() || (quarkusPluginDependency = this.findQuarkusPluginDependency(firstLevelDeps)) == null) continue;
            quarkusPluginDependency.getAllModuleArtifacts().stream().map(ResolvedArtifact::getFile).forEach(f -> this.addToClassPaths(classPathManifest, (File)f));
            foundQuarkusPlugin = true;
            break;
        }
        if (!foundQuarkusPlugin) {
            String pluginUnderTestMetaData = System.getProperty("plugin-under-test-metadata.properties");
            if (pluginUnderTestMetaData != null) {
                Path p = Paths.get(pluginUnderTestMetaData, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    Properties props = new Properties();
                    try {
                        String[] stringArray = null;
                        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                            props.load(is);
                        }
                        catch (Throwable object) {
                            stringArray = object;
                            throw object;
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read " + p, e);
                    }
                    String classpath = props.getProperty("implementation-classpath");
                    for (String cpElement : classpath.split(File.pathSeparator)) {
                        File f2 = new File(cpElement);
                        if (!f2.exists()) continue;
                        this.addToClassPaths(classPathManifest, f2);
                    }
                }
            } else {
                throw new IllegalStateException("Unable to find quarkus-gradle-plugin dependency in " + this.getProject());
            }
        }
    }

    private void addToClassPaths(StringBuilder classPathManifest, File file) {
        if (this.filesIncludedInClasspath.add(file)) {
            this.getProject().getLogger().debug("Adding dependency {}", (Object)file);
            URI uri = file.toPath().toAbsolutePath().toUri();
            classPathManifest.append(uri).append(" ");
        }
    }
}

