/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.builder;

import io.quarkus.bootstrap.resolver.model.ArtifactCoords;
import io.quarkus.bootstrap.resolver.model.ModelParameter;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.SourceSet;
import io.quarkus.bootstrap.resolver.model.Workspace;
import io.quarkus.bootstrap.resolver.model.WorkspaceModule;
import io.quarkus.bootstrap.resolver.model.impl.ArtifactCoordsImpl;
import io.quarkus.bootstrap.resolver.model.impl.DependencyImpl;
import io.quarkus.bootstrap.resolver.model.impl.ModelParameterImpl;
import io.quarkus.bootstrap.resolver.model.impl.QuarkusModelImpl;
import io.quarkus.bootstrap.resolver.model.impl.SourceSetImpl;
import io.quarkus.bootstrap.resolver.model.impl.WorkspaceImpl;
import io.quarkus.bootstrap.resolver.model.impl.WorkspaceModuleImpl;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class QuarkusModelBuilder
implements ParameterizedToolingModelBuilder<ModelParameter> {
    private static Configuration classpathConfig(Project project, LaunchMode mode) {
        if (LaunchMode.TEST.equals((Object)mode)) {
            return project.getConfigurations().getByName("testRuntimeClasspath");
        }
        if (LaunchMode.DEVELOPMENT.equals((Object)mode)) {
            return ((Configuration)project.getConfigurations().create("quarkusDevMode")).extendsFrom(new Configuration[]{project.getConfigurations().getByName("compileOnly"), project.getConfigurations().getByName("runtimeClasspath")});
        }
        return project.getConfigurations().getByName("runtimeClasspath");
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(QuarkusModel.class.getName());
    }

    public Class<ModelParameter> getParameterType() {
        return ModelParameter.class;
    }

    public Object buildAll(String modelName, Project project) {
        ModelParameterImpl modelParameter = new ModelParameterImpl();
        modelParameter.setMode(LaunchMode.DEVELOPMENT.toString());
        return this.buildAll(modelName, (ModelParameter)modelParameter, project);
    }

    public Object buildAll(String modelName, ModelParameter parameter, Project project) {
        LaunchMode mode = LaunchMode.valueOf((String)parameter.getMode());
        Set<Dependency> deploymentDeps = this.getEnforcedPlatforms(project);
        LinkedHashMap<ArtifactCoords, io.quarkus.bootstrap.resolver.model.Dependency> appDependencies = new LinkedHashMap<ArtifactCoords, io.quarkus.bootstrap.resolver.model.Dependency>();
        HashSet<ArtifactCoords> visitedDeps = new HashSet<ArtifactCoords>();
        ResolvedConfiguration configuration = QuarkusModelBuilder.classpathConfig(project, mode).getResolvedConfiguration();
        this.collectDependencies(configuration, mode, project, appDependencies);
        this.collectFirstMetDeploymentDeps(configuration.getFirstLevelModuleDependencies(), appDependencies, deploymentDeps, visitedDeps);
        List<io.quarkus.bootstrap.resolver.model.Dependency> extensionDependencies = this.collectExtensionDependencies(project, deploymentDeps);
        ArtifactCoordsImpl appArtifactCoords = new ArtifactCoordsImpl(project.getGroup().toString(), project.getName(), project.getVersion().toString());
        return new QuarkusModelImpl((Workspace)new WorkspaceImpl((ArtifactCoords)appArtifactCoords, this.getWorkspace(project.getRootProject(), mode)), new LinkedList(appDependencies.values()), extensionDependencies, deploymentDeps.stream().map(QuarkusModelBuilder::toEnforcedPlatformDependency).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public Set<WorkspaceModule> getWorkspace(Project project, LaunchMode mode) {
        HashSet<WorkspaceModule> modules = new HashSet<WorkspaceModule>();
        for (Project subproject : project.getAllprojects()) {
            Convention convention = subproject.getConvention();
            JavaPluginConvention javaConvention = (JavaPluginConvention)convention.findPlugin(JavaPluginConvention.class);
            if (javaConvention == null || !javaConvention.getSourceSets().getNames().contains("main")) continue;
            modules.add(this.getWorkspaceModule(subproject, mode));
        }
        return modules;
    }

    private WorkspaceModule getWorkspaceModule(Project project, LaunchMode mode) {
        ArtifactCoordsImpl appArtifactCoords = new ArtifactCoordsImpl(project.getGroup().toString(), project.getName(), project.getVersion().toString());
        org.gradle.api.tasks.SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(project, "main");
        SourceSetImpl modelSourceSet = this.convert(mainSourceSet);
        return new WorkspaceModuleImpl((ArtifactCoords)appArtifactCoords, project.getProjectDir().getAbsoluteFile(), project.getBuildDir().getAbsoluteFile(), this.getSourceSourceSet(mainSourceSet), (SourceSet)modelSourceSet);
    }

    private Set<Dependency> getEnforcedPlatforms(Project project) {
        HashSet<Dependency> directExtension = new HashSet<Dependency>();
        Configuration impl = project.getConfigurations().getByName("implementation");
        for (Dependency d : impl.getAllDependencies()) {
            ModuleDependency module;
            Category category;
            if (!(d instanceof ModuleDependency) || (category = (Category)(module = (ModuleDependency)d).getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)) == null || !"enforced-platform".equals(category.getName())) continue;
            directExtension.add(d);
        }
        return directExtension;
    }

    private void collectFirstMetDeploymentDeps(Set<ResolvedDependency> dependencies, Map<ArtifactCoords, io.quarkus.bootstrap.resolver.model.Dependency> appDependencies, Set<Dependency> extensionDeps, Set<ArtifactCoords> visited) {
        for (ResolvedDependency d : dependencies) {
            boolean addChildExtension = true;
            boolean wasDependencyVisited = false;
            for (ResolvedArtifact artifact : d.getModuleArtifacts()) {
                io.quarkus.bootstrap.resolver.model.Dependency appDep;
                ModuleVersionIdentifier moduleIdentifier = artifact.getModuleVersion().getId();
                ArtifactCoords key = QuarkusModelBuilder.toAppDependenciesKey(moduleIdentifier.getGroup(), moduleIdentifier.getName(), artifact.getClassifier());
                if (!visited.add(key) || (appDep = appDependencies.get(key)) == null) continue;
                wasDependencyVisited = true;
                Dependency deploymentArtifact = this.getDeploymentArtifact(appDep);
                if (deploymentArtifact == null) continue;
                extensionDeps.add(deploymentArtifact);
                addChildExtension = false;
            }
            Set resolvedChildren = d.getChildren();
            if (!wasDependencyVisited || !addChildExtension || resolvedChildren.isEmpty()) continue;
            this.collectFirstMetDeploymentDeps(resolvedChildren, appDependencies, extensionDeps, visited);
        }
    }

    private Dependency getDeploymentArtifact(io.quarkus.bootstrap.resolver.model.Dependency dependency) {
        for (File file : dependency.getPaths()) {
            Properties depsProperties;
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                Path quarkusDescr = file.toPath().resolve("META-INF").resolve("quarkus-extension.properties");
                if (!Files.exists(quarkusDescr, new LinkOption[0])) continue;
                depsProperties = QuarkusModelHelper.resolveDescriptor((Path)quarkusDescr);
            } else {
                try {
                    FileSystem artifactFs = FileSystems.newFileSystem(file.toPath(), this.getClass().getClassLoader());
                    Throwable throwable = null;
                    try {
                        Path quarkusDescr = artifactFs.getPath("META-INF", new String[0]).resolve("quarkus-extension.properties");
                        if (!Files.exists(quarkusDescr, new LinkOption[0])) continue;
                        depsProperties = QuarkusModelHelper.resolveDescriptor((Path)quarkusDescr);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (artifactFs == null) continue;
                        if (throwable != null) {
                            try {
                                artifactFs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        artifactFs.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new GradleException("Failed to process " + file, (Throwable)e);
                }
            }
            String value = depsProperties.getProperty("deployment-artifact");
            String[] split = value.split(":");
            return new DefaultExternalModuleDependency(split[0], split[1], split[2], null);
        }
        return null;
    }

    private List<io.quarkus.bootstrap.resolver.model.Dependency> collectExtensionDependencies(Project project, Collection<Dependency> extensions) {
        LinkedList<io.quarkus.bootstrap.resolver.model.Dependency> platformDependencies = new LinkedList<io.quarkus.bootstrap.resolver.model.Dependency>();
        Configuration deploymentConfig = project.getConfigurations().detachedConfiguration(extensions.toArray(new Dependency[0]));
        ResolvedConfiguration rc = deploymentConfig.getResolvedConfiguration();
        for (ResolvedArtifact a : rc.getResolvedArtifacts()) {
            if (!QuarkusModelBuilder.isDependency(a)) continue;
            io.quarkus.bootstrap.resolver.model.Dependency dependency = QuarkusModelBuilder.toDependency(a);
            platformDependencies.add(dependency);
        }
        return platformDependencies;
    }

    private void collectDependencies(ResolvedConfiguration configuration, LaunchMode mode, Project project, Map<ArtifactCoords, io.quarkus.bootstrap.resolver.model.Dependency> appDependencies) {
        Set artifacts = configuration.getResolvedArtifacts();
        HashSet<File> artifactFiles = null;
        if (artifacts.size() < configuration.getFiles().size()) {
            artifactFiles = new HashSet<File>(artifacts.size());
        }
        for (ResolvedArtifact a : artifacts) {
            if (!QuarkusModelBuilder.isDependency(a)) continue;
            DependencyImpl dep = QuarkusModelBuilder.initDependency(a);
            if (LaunchMode.DEVELOPMENT.equals((Object)mode) && a.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier) {
                Project projectDep = project.getRootProject().findProject(((ProjectComponentIdentifier)a.getId().getComponentIdentifier()).getProjectPath());
                this.addDevModePaths(dep, a, projectDep);
            } else {
                dep.addPath(a.getFile());
            }
            appDependencies.put(QuarkusModelBuilder.toAppDependenciesKey(dep.getGroupId(), dep.getName(), dep.getClassifier()), (io.quarkus.bootstrap.resolver.model.Dependency)dep);
            if (artifactFiles == null) continue;
            artifactFiles.add(a.getFile());
        }
        if (artifactFiles != null) {
            for (File f : configuration.getFiles()) {
                int dot;
                if (artifactFiles.contains(f)) continue;
                String parentPath = f.getParent();
                String group = HashUtil.sha1((String)(parentPath == null ? f.getName() : parentPath));
                String name = f.getName();
                String type = "jar";
                if (!f.isDirectory() && (dot = f.getName().lastIndexOf(46)) > 0) {
                    name = f.getName().substring(0, dot);
                    type = f.getName().substring(dot + 1);
                }
                String version = String.valueOf(f.lastModified());
                ArtifactCoords key = QuarkusModelBuilder.toAppDependenciesKey(group, name, "");
                DependencyImpl dep = new DependencyImpl(name, group, version, "compile", type, null);
                dep.addPath(f);
                appDependencies.put(key, (io.quarkus.bootstrap.resolver.model.Dependency)dep);
            }
        }
    }

    private void addDevModePaths(DependencyImpl dep, ResolvedArtifact a, Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            dep.addPath(a.getFile());
        } else {
            org.gradle.api.tasks.SourceSet mainSourceSet = (org.gradle.api.tasks.SourceSet)javaConvention.getSourceSets().findByName("main");
            if (mainSourceSet != null) {
                File classesDir = new File(QuarkusGradleUtils.getClassesDir(mainSourceSet, project.getBuildDir(), false));
                if (classesDir.exists()) {
                    dep.addPath(classesDir);
                }
                for (File resourcesDir : mainSourceSet.getResources().getSourceDirectories()) {
                    if (!resourcesDir.exists()) continue;
                    dep.addPath(resourcesDir);
                }
                for (File outputDir : ((Task)project.getTasks().findByName("processResources")).getOutputs().getFiles()) {
                    if (!outputDir.exists()) continue;
                    dep.addPath(outputDir);
                }
            } else {
                dep.addPath(a.getFile());
            }
        }
    }

    private SourceSetImpl convert(org.gradle.api.tasks.SourceSet sourceSet) {
        if (sourceSet.getOutput().getResourcesDir().exists()) {
            return new SourceSetImpl(sourceSet.getOutput().getClassesDirs().getFiles(), sourceSet.getOutput().getResourcesDir());
        }
        return new SourceSetImpl(sourceSet.getOutput().getClassesDirs().getFiles());
    }

    private SourceSet getSourceSourceSet(org.gradle.api.tasks.SourceSet sourceSet) {
        return new SourceSetImpl(sourceSet.getAllJava().getSrcDirs(), sourceSet.getResources().getSourceDirectories().getSingleFile());
    }

    private static boolean isDependency(ResolvedArtifact a) {
        return "jar".equalsIgnoreCase(a.getExtension()) || "exe".equalsIgnoreCase(a.getExtension()) || a.getFile().isDirectory();
    }

    static io.quarkus.bootstrap.resolver.model.Dependency toDependency(ResolvedArtifact a) {
        DependencyImpl dependency = QuarkusModelBuilder.initDependency(a);
        dependency.addPath(a.getFile());
        return dependency;
    }

    static io.quarkus.bootstrap.resolver.model.Dependency toEnforcedPlatformDependency(Dependency dependency) {
        ExternalModuleDependency emd;
        Category category;
        if (dependency instanceof ExternalModuleDependency && (category = (Category)(emd = (ExternalModuleDependency)dependency).getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)) != null && "enforced-platform".equals(category.getName())) {
            return new DependencyImpl(emd.getName(), emd.getGroup(), emd.getVersion(), "compile", "pom", null);
        }
        return null;
    }

    private static DependencyImpl initDependency(ResolvedArtifact a) {
        String[] split = a.getModuleVersion().toString().split(":");
        return new DependencyImpl(split[1], split[0], split.length > 2 ? split[2] : null, "compile", a.getType(), a.getClassifier());
    }

    private static ArtifactCoords toAppDependenciesKey(String groupId, String artifactId, String classifier) {
        classifier = classifier == null ? "" : classifier;
        return new ArtifactCoordsImpl(groupId, artifactId, classifier, "", "jar");
    }
}

