/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.BuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.gradle.GradleBuildFileFromConnector;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.platform.descriptor.CombinedQuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.resolver.json.QuarkusJsonPlatformDescriptorResolver;
import io.quarkus.platform.tools.MessageWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;
import org.gradle.api.tasks.Internal;

public abstract class QuarkusPlatformTask
extends QuarkusTask {
    QuarkusPlatformTask(String description) {
        super(description);
    }

    protected QuarkusPlatformDescriptor platformDescriptor() {
        QuarkusJsonPlatformDescriptorResolver platformResolver = QuarkusJsonPlatformDescriptorResolver.newInstance().setArtifactResolver(this.extension().getAppModelResolver()).setMessageWriter((MessageWriter)new GradleMessageWriter(this.getProject().getLogger()));
        ArrayList platforms = new ArrayList(2);
        Configuration impl = this.getProject().getConfigurations().getByName("implementation");
        impl.getIncoming().getDependencies().forEach(d -> {
            if (!(d instanceof ModuleDependency)) {
                return;
            }
            ModuleDependency module = (ModuleDependency)d;
            Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            if (category == null || !"enforced-platform".equals(category.getName())) {
                return;
            }
            try {
                platforms.add(platformResolver.resolveFromBom(module.getGroup(), module.getName(), module.getVersion()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (platforms.isEmpty()) {
            throw new GradleException("Failed to determine Quarkus platform for the project");
        }
        if (platforms.size() == 1) {
            return (QuarkusPlatformDescriptor)platforms.get(0);
        }
        CombinedQuarkusPlatformDescriptor.Builder builder = CombinedQuarkusPlatformDescriptor.builder();
        for (QuarkusPlatformDescriptor platform : platforms) {
            builder.addPlatform(platform);
        }
        return builder.build();
    }

    @Internal
    protected BuildFile getGradleBuildFile() {
        Path projectDirPath = this.getProject().getProjectDir().toPath();
        Path rootProjectPath = this.getProject().getParent() != null ? this.getProject().getRootProject().getProjectDir().toPath() : null;
        return new GradleBuildFileFromConnector(projectDirPath, this.platformDescriptor(), rootProjectPath);
    }

    @Internal
    protected QuarkusProject getQuarkusProject() {
        return QuarkusProject.of((Path)this.getProject().getProjectDir().toPath(), (QuarkusPlatformDescriptor)this.platformDescriptor(), (ExtensionManager)this.getGradleBuildFile());
    }

    protected static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GradleException("Malformed URL:" + url, (Throwable)e);
        }
    }
}

