/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusBuild
extends QuarkusTask {
    private static final String NATIVE_PROPERTY_NAMESPACE = "quarkus.native";
    private boolean uberJar;
    private List<String> ignoredEntries = new ArrayList<String>();

    public QuarkusBuild() {
        super("Quarkus builds a runner jar based on the build jar");
    }

    public QuarkusBuild nativeArgs(Action<Map<String, ?>> action) {
        HashMap nativeArgsMap = new HashMap();
        action.execute(nativeArgsMap);
        for (Map.Entry nativeArg : nativeArgsMap.entrySet()) {
            System.setProperty(this.expandConfigurationKey((String)nativeArg.getKey()), nativeArg.getValue().toString());
        }
        return this;
    }

    @Input
    public boolean isUberJar() {
        return this.uberJar;
    }

    @Option(description="Set to true if the build task should build an uberjar", option="uber-jar")
    public void setUberJar(boolean uberJar) {
        this.uberJar = uberJar;
    }

    @Optional
    @Input
    public List<String> getIgnoredEntries() {
        return this.ignoredEntries;
    }

    @Option(description="When using the uber-jar option, this option can be used to specify one or more entries that should be excluded from the final jar", option="ignored-entry")
    public void setIgnoredEntries(List<String> ignoredEntries) {
        this.ignoredEntries.addAll(ignoredEntries);
    }

    @Classpath
    public FileCollection getClasspath() {
        SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(this.getProject(), "main");
        return mainSourceSet.getCompileClasspath().plus(mainSourceSet.getRuntimeClasspath()).plus(mainSourceSet.getAnnotationProcessorPath()).plus((FileCollection)mainSourceSet.getResources());
    }

    @OutputFile
    public File getRunnerJar() {
        return new File(this.getProject().getBuildDir(), this.extension().finalName() + "-runner.jar");
    }

    @OutputFile
    public File getNativeRunner() {
        return new File(this.getProject().getBuildDir(), this.extension().finalName() + "-runner");
    }

    @OutputDirectory
    public File getFastJar() {
        return new File(this.getProject().getBuildDir(), "quarkus-app");
    }

    @TaskAction
    public void buildQuarkus() {
        this.getLogger().lifecycle("building quarkus jar");
        AppArtifact appArtifact = this.extension().getAppArtifact();
        appArtifact.setPaths(QuarkusGradleUtils.getOutputPaths(this.getProject()));
        AppModelResolver modelResolver = this.extension().getAppModelResolver();
        Properties effectiveProperties = this.getBuildSystemProperties(appArtifact);
        if (this.ignoredEntries != null && this.ignoredEntries.size() > 0) {
            String joinedEntries = String.join((CharSequence)",", this.ignoredEntries);
            effectiveProperties.setProperty("quarkus.package.user-configured-ignored-entries", joinedEntries);
        }
        boolean clear = false;
        if (this.uberJar && System.getProperty("quarkus.package.uber-jar") == null) {
            System.setProperty("quarkus.package.uber-jar", "true");
            clear = true;
        }
        try (CuratedApplication appCreationContext = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setAppModelResolver(modelResolver).setTargetDirectory(this.getProject().getBuildDir().toPath()).setBaseName(this.extension().finalName()).setBuildSystemProperties(effectiveProperties).setAppArtifact(appArtifact).setLocalProjectDiscovery(false).setIsolateDeployment(true).build().bootstrap();){
            appCreationContext.createAugmentor("io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled$Factory", Collections.emptyMap()).createProductionApplication();
        }
        catch (BootstrapException e) {
            throw new GradleException("Failed to build a runnable JAR", (Throwable)e);
        }
        finally {
            if (clear) {
                System.clearProperty("quarkus.package.uber-jar");
            }
        }
    }

    private String expandConfigurationKey(String shortKey) {
        String hyphenatedKey = StringUtil.hyphenate((String)shortKey);
        if (hyphenatedKey.startsWith(NATIVE_PROPERTY_NAMESPACE)) {
            return hyphenatedKey;
        }
        return String.format("%s.%s", NATIVE_PROPERTY_NAMESPACE, hyphenatedKey);
    }
}

