/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.GradleGroovyProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleKotlinProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleProjectBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;

public abstract class QuarkusPlatformTask
extends QuarkusTask {
    private static boolean isEnableRegistryClient() {
        String value = System.getProperty("enableRegistryClient");
        return value == null ? System.getProperties().containsKey("enableRegistryClient") : Boolean.parseBoolean(value);
    }

    QuarkusPlatformTask(String description) {
        super(description);
    }

    private ExtensionCatalog extensionsCatalog(boolean limitExtensionsToImportedPlatforms, MessageWriter log) {
        ExtensionCatalogResolver catalogResolver;
        List<ArtifactCoords> platforms = this.importedPlatforms();
        ExtensionCatalogResolver extensionCatalogResolver = catalogResolver = QuarkusPlatformTask.isEnableRegistryClient() ? QuarkusProjectHelper.getCatalogResolver((MessageWriter)log) : ExtensionCatalogResolver.empty();
        if (catalogResolver.hasRegistries()) {
            try {
                return limitExtensionsToImportedPlatforms ? catalogResolver.resolveExtensionCatalog(platforms) : catalogResolver.resolveExtensionCatalog(this.quarkusCoreVersion());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve extensions catalog", e);
            }
        }
        return ToolsUtils.mergePlatforms(platforms, (AppModelResolver)this.extension().getAppModelResolver());
    }

    protected List<ArtifactCoords> importedPlatforms() {
        List<Dependency> bomDeps = this.boms();
        if (bomDeps.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        Configuration boms = this.getProject().getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        HashSet processedKeys = new HashSet(1);
        ArrayList<ArtifactCoords> platforms = new ArrayList<ArtifactCoords>();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (!d.getTarget().getName().endsWith("-quarkus-platform-descriptor") || !processedKeys.add(new AppArtifactKey(d.getTarget().getGroup(), d.getTarget().getName()))) {
                return;
            }
            ArtifactCoords platform = new ArtifactCoords(d.getTarget().getGroup(), d.getTarget().getName(), d.getTarget().getVersion(), "json", d.getTarget().getVersion());
            platforms.add(platform);
        });
        boms.getResolvedConfiguration();
        if (platforms.isEmpty()) {
            throw new RuntimeException("No Quarkus platforms found in the project");
        }
        return platforms;
    }

    protected String quarkusCoreVersion() {
        List<Dependency> bomDeps = this.boms();
        if (bomDeps.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        Configuration boms = this.getProject().getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        AtomicReference quarkusVersionRef = new AtomicReference();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (quarkusVersionRef.get() == null && d.getTarget().getName().equals("quarkus-core") && d.getTarget().getGroup().equals("io.quarkus")) {
                quarkusVersionRef.set(d.getTarget().getVersion());
            }
        });
        boms.getResolvedConfiguration();
        String quarkusCoreVersion = (String)quarkusVersionRef.get();
        if (quarkusCoreVersion == null) {
            throw new IllegalStateException("Failed to determine the Quarkus core version for the project");
        }
        return quarkusCoreVersion;
    }

    private List<Dependency> boms() {
        Configuration impl = this.getProject().getConfigurations().getByName("implementation");
        ArrayList<Dependency> boms = new ArrayList<Dependency>();
        impl.getIncoming().getDependencies().forEach(d -> {
            if (!(d instanceof ModuleDependency)) {
                return;
            }
            ModuleDependency module = (ModuleDependency)d;
            Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            if (category != null && ("enforced-platform".equals(category.getName()) || "platform".equals(category.getName()))) {
                boms.add((Dependency)d);
            }
        });
        return boms;
    }

    protected QuarkusProject getQuarkusProject(boolean limitExtensionsToImportedPlatforms) {
        GradleProjectBuildFile buildFile;
        Path rootProjectPath;
        GradleMessageWriter log = this.messageWriter();
        ExtensionCatalog catalog = this.extensionsCatalog(limitExtensionsToImportedPlatforms, log);
        Path projectDirPath = this.getProject().getProjectDir().toPath();
        Path path = rootProjectPath = this.getProject().getParent() != null ? this.getProject().getRootProject().getProjectDir().toPath() : projectDirPath;
        if (Files.exists(rootProjectPath.resolve("settings.gradle.kts"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle.kts"), new LinkOption[0])) {
            buildFile = new GradleKotlinProjectBuildFile(this.getProject(), catalog);
        } else if (Files.exists(rootProjectPath.resolve("settings.gradle"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle"), new LinkOption[0])) {
            buildFile = new GradleGroovyProjectBuildFile(this.getProject(), catalog);
        } else {
            throw new GradleException("Mixed DSL is not supported. Both build and settings file need to use either Kotlin or Groovy DSL");
        }
        return QuarkusProjectHelper.getProject((Path)this.getProject().getProjectDir().toPath(), (ExtensionCatalog)catalog, (ExtensionManager)buildFile, (MessageWriter)log);
    }

    protected GradleMessageWriter messageWriter() {
        return new GradleMessageWriter(this.getProject().getLogger());
    }

    protected static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GradleException("Malformed URL:" + url, (Throwable)e);
        }
    }
}

