/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.QuarkusDevModeLauncher;
import io.quarkus.gradle.tasks.GradleDevModeLauncher;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;

public class QuarkusDev
extends QuarkusTask {
    private Set<File> filesIncludedInClasspath = new HashSet<File>();
    private File buildDir;
    private String sourceDir;
    private String workingDir;
    private List<String> jvmArgs;
    private boolean preventnoverify = false;
    private List<String> args = new LinkedList<String>();
    private List<String> compilerArgs = new LinkedList<String>();

    @Inject
    public QuarkusDev() {
        super("Development mode: enables hot deployment with background compilation");
    }

    public QuarkusDev(String name) {
        super(name);
    }

    @InputDirectory
    @Optional
    public File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = this.getProject().getBuildDir();
        }
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    @Optional
    @InputDirectory
    public File getSourceDir() {
        if (this.sourceDir == null) {
            return this.extension().sourceDir();
        }
        return new File(this.sourceDir);
    }

    @Option(description="Set source directory", option="source-dir")
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Input
    public String getWorkingDir() {
        if (this.workingDir == null) {
            return this.extension().workingDir().toString();
        }
        return this.workingDir;
    }

    @Option(description="Set working directory", option="working-dir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Optional
    @Input
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    @Optional
    @Input
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Option(description="Set application arguments", option="quarkus-args")
    public void setArgsString(String argsString) {
        this.setArgs(Arrays.asList(Commandline.translateCommandline((String)argsString)));
    }

    @Input
    public boolean isPreventnoverify() {
        return this.preventnoverify;
    }

    @Option(description="value is intended to be set to true when some generated bytecode is erroneous causing the JVM to crash when the verify:none option is set (which is on by default)", option="prevent-noverify")
    public void setPreventnoverify(boolean preventnoverify) {
        this.preventnoverify = preventnoverify;
    }

    @Optional
    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Option(description="Additional parameters to pass to javac when recompiling changed source files", option="compiler-args")
    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    @TaskAction
    public void startDev() {
        if (!this.getSourceDir().isDirectory()) {
            throw new GradleException("The `src/main/java` directory is required, please create it.");
        }
        if (!this.extension().outputDirectory().isDirectory()) {
            throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
        }
        try {
            QuarkusDevModeLauncher runner = this.newLauncher();
            this.getProject().exec(action -> {
                action.commandLine((Iterable)runner.args()).workingDir((Object)this.getWorkingDir());
                action.setStandardInput(System.in).setErrorOutput((OutputStream)System.out).setStandardOutput((OutputStream)System.out);
            });
        }
        catch (Exception e) {
            throw new GradleException("Failed to run", (Throwable)e);
        }
    }

    private QuarkusDevModeLauncher newLauncher() throws Exception {
        AppModel appModel;
        Project project = this.getProject();
        GradleDevModeLauncher.Builder builder = (GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)GradleDevModeLauncher.builder(this.getLogger()).preventnoverify(this.isPreventnoverify())).projectDir(project.getProjectDir())).buildDir(this.getBuildDir())).outputDir(this.getBuildDir())).debug(System.getProperty("debug"))).debugHost(System.getProperty("debugHost", "localhost"))).suspend(System.getProperty("suspend"));
        if (this.getJvmArgs() != null) {
            builder.jvmArgs(this.getJvmArgs());
        }
        for (Map.Entry e : project.getProperties().entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            builder.buildSystemProperty((String)e.getKey(), e.getValue().toString());
        }
        builder.applicationName(project.getName());
        if (project.getVersion() != null) {
            builder.applicationVersion(project.getVersion().toString());
        }
        builder.sourceEncoding(this.getSourceEncoding());
        AppModelResolver modelResolver = this.extension().getAppModelResolver(LaunchMode.DEVELOPMENT);
        try {
            AppArtifact appArtifact = this.extension().getAppArtifact();
            appArtifact.setPaths(QuarkusGradleUtils.getOutputPaths(project));
            appModel = modelResolver.resolveModel(appArtifact);
        }
        catch (AppModelResolverException e) {
            throw new GradleException("Failed to resolve application model " + this.extension().getAppArtifact() + " dependencies", (Throwable)e);
        }
        HashSet<AppArtifactKey> projectDependencies = new HashSet<AppArtifactKey>();
        this.addSelfWithLocalDeps(project, builder, new HashSet<String>(), projectDependencies, true);
        for (AppDependency appDependency : appModel.getFullDeploymentDeps()) {
            AppArtifact appArtifact = appDependency.getArtifact();
            if (appArtifact.getGroupId().equals("io.quarkus") && appArtifact.getGroupId().equals("quarkus-ide-launcher") || projectDependencies.contains(new AppArtifactKey(appArtifact.getGroupId(), appArtifact.getArtifactId()))) continue;
            appArtifact.getPaths().forEach(p -> {
                if (Files.exists(p, new LinkOption[0])) {
                    if (appArtifact.getGroupId().equals("io.quarkus") && appArtifact.getArtifactId().equals("quarkus-class-change-agent")) {
                        builder.jvmArgs("-javaagent:" + p.toFile().getAbsolutePath());
                    } else {
                        this.addToClassPaths(builder, p.toFile());
                    }
                }
            });
        }
        this.addGradlePluginDeps(builder);
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention != null) {
            builder.sourceJavaVersion(javaPluginConvention.getSourceCompatibility().toString());
            builder.targetJavaVersion(javaPluginConvention.getTargetCompatibility().toString());
        }
        if (this.getCompilerArgs().isEmpty()) {
            this.getJavaCompileTask().map(compileTask -> compileTask.getOptions().getCompilerArgs()).ifPresent(arg_0 -> ((GradleDevModeLauncher.Builder)builder).compilerOptions(arg_0));
        } else {
            builder.compilerOptions(this.getCompilerArgs());
        }
        this.modifyDevModeContext(builder);
        Path serializedModel = QuarkusGradleUtils.serializeAppModel(appModel, (Task)this);
        serializedModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + serializedModel.toAbsolutePath());
        this.extension().outputDirectory().mkdirs();
        if (!this.args.isEmpty()) {
            builder.applicationArgs(String.join((CharSequence)" ", this.args));
        }
        return builder.build();
    }

    protected void modifyDevModeContext(GradleDevModeLauncher.Builder builder) {
    }

    private void addSelfWithLocalDeps(Project project, GradleDevModeLauncher.Builder builder, Set<String> visited, Set<AppArtifactKey> addedDeps, boolean root) {
        if (!visited.add(project.getPath())) {
            return;
        }
        Configuration compileCp = (Configuration)project.getConfigurations().findByName("compileClasspath");
        if (compileCp != null) {
            compileCp.getIncoming().getDependencies().forEach(d -> {
                if (d instanceof ProjectDependency) {
                    this.addSelfWithLocalDeps(((ProjectDependency)d).getDependencyProject(), builder, visited, addedDeps, false);
                }
            });
        }
        this.addLocalProject(project, builder, addedDeps, root);
    }

    private void addLocalProject(Project project, GradleDevModeLauncher.Builder builder, Set<AppArtifactKey> addeDeps, boolean root) {
        String resourcesOutputPath;
        AppArtifactKey key = new AppArtifactKey(project.getGroup().toString(), project.getName());
        if (addeDeps.contains(key)) {
            return;
        }
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            return;
        }
        SourceSetContainer sourceSets = javaConvention.getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.findByName("main");
        if (mainSourceSet == null) {
            return;
        }
        HashSet<String> sourcePaths = new HashSet<String>();
        HashSet<String> sourceParentPaths = new HashSet<String>();
        for (File sourceDir : mainSourceSet.getAllJava().getSrcDirs()) {
            if (!sourceDir.exists()) continue;
            sourcePaths.add(sourceDir.getAbsolutePath());
            sourceParentPaths.add(sourceDir.toPath().getParent().toAbsolutePath().toString());
        }
        File resourcesSrcDir = mainSourceSet.getResources().getSourceDirectories().getSingleFile();
        File resourcesOutputDir = mainSourceSet.getOutput().getResourcesDir();
        if (sourcePaths.isEmpty() && !resourcesOutputDir.exists()) {
            return;
        }
        String classesDir = QuarkusGradleUtils.getClassesDir(mainSourceSet, project.getBuildDir());
        if (resourcesOutputDir.exists()) {
            resourcesOutputPath = resourcesOutputDir.getAbsolutePath();
            if (!Files.exists(Paths.get(classesDir, new String[0]), new LinkOption[0])) {
                classesDir = resourcesOutputPath;
            }
        } else {
            resourcesOutputPath = classesDir;
        }
        DevModeContext.ModuleInfo wsModuleInfo = new DevModeContext.ModuleInfo(key, project.getName(), project.getProjectDir().getAbsolutePath(), sourcePaths, classesDir, resourcesSrcDir.getAbsolutePath(), resourcesOutputPath, sourceParentPaths, project.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString(), project.getBuildDir().toString());
        if (root) {
            builder.mainModule(wsModuleInfo);
        } else {
            builder.dependency(wsModuleInfo);
        }
        addeDeps.add(key);
    }

    private String getSourceEncoding() {
        return this.getJavaCompileTask().map(javaCompile -> javaCompile.getOptions().getEncoding()).orElse(null);
    }

    private java.util.Optional<JavaCompile> getJavaCompileTask() {
        return java.util.Optional.ofNullable((JavaCompile)this.getProject().getTasks().getByName("compileJava"));
    }

    private ResolvedDependency findQuarkusPluginDependency(Set<ResolvedDependency> dependencies) {
        for (ResolvedDependency rd : dependencies) {
            ResolvedDependency quarkusPluginDependency;
            if ("io.quarkus.gradle.plugin".equals(rd.getModuleName())) {
                return rd;
            }
            Set children = rd.getChildren();
            if (children == null || (quarkusPluginDependency = this.findQuarkusPluginDependency(children)) == null) continue;
            return quarkusPluginDependency;
        }
        return null;
    }

    private void addGradlePluginDeps(GradleDevModeLauncher.Builder builder) {
        boolean foundQuarkusPlugin = false;
        for (Project prj = this.getProject(); prj != null && !foundQuarkusPlugin; prj = prj.getParent()) {
            ResolvedDependency quarkusPluginDependency;
            Set firstLevelDeps = prj.getBuildscript().getConfigurations().getByName("classpath").getResolvedConfiguration().getFirstLevelModuleDependencies();
            if (firstLevelDeps.isEmpty() || (quarkusPluginDependency = this.findQuarkusPluginDependency(firstLevelDeps)) == null) continue;
            quarkusPluginDependency.getAllModuleArtifacts().stream().map(ResolvedArtifact::getFile).forEach(f -> this.addToClassPaths(builder, (File)f));
            foundQuarkusPlugin = true;
            break;
        }
        if (!foundQuarkusPlugin) {
            String pluginUnderTestMetaData = System.getProperty("plugin-under-test-metadata.properties");
            if (pluginUnderTestMetaData != null) {
                Path p = Paths.get(pluginUnderTestMetaData, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    Properties props = new Properties();
                    try {
                        String[] stringArray = null;
                        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                            props.load(is);
                        }
                        catch (Throwable object) {
                            stringArray = object;
                            throw object;
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read " + p, e);
                    }
                    String classpath = props.getProperty("implementation-classpath");
                    for (String cpElement : classpath.split(File.pathSeparator)) {
                        File f2 = new File(cpElement);
                        if (!f2.exists()) continue;
                        this.addToClassPaths(builder, f2);
                    }
                }
            } else {
                throw new IllegalStateException("Unable to find quarkus-gradle-plugin dependency in " + this.getProject());
            }
        }
    }

    private void addToClassPaths(GradleDevModeLauncher.Builder classPathManifest, File file) {
        if (this.filesIncludedInClasspath.add(file)) {
            this.getProject().getLogger().debug("Adding dependency {}", (Object)file);
            classPathManifest.classpathEntry(file);
        }
    }
}

