/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;

public class AppModelGradleResolver
implements AppModelResolver {
    private AppModel appModel;
    private final Project project;
    private final QuarkusModel model;

    public AppModelGradleResolver(Project project, QuarkusModel model) {
        this.model = model;
        this.project = project;
    }

    public String getLatestVersion(AppArtifact appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        try {
            return this.resolveArtifact(new AppArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), "[" + appArtifact.getVersion() + "," + upToVersion + (inclusive ? "]" : ")"))).getVersion();
        }
        catch (AppModelResolverException e) {
            return null;
        }
    }

    public String getLatestVersionFromRange(AppArtifact appArtifact, String range) throws AppModelResolverException {
        try {
            return this.resolveArtifact(new AppArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), range)).getVersion();
        }
        catch (AppModelResolverException e) {
            return null;
        }
    }

    public String getNextVersion(AppArtifact appArtifact, String fromVersion, boolean fromVersionIncluded, String upToVersion, boolean upToVersionIncluded) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public List<String> listLaterVersions(AppArtifact appArtifact, String upToVersion, boolean inclusive) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public void relink(AppArtifact appArtifact, Path localPath) throws AppModelResolverException {
    }

    public Path resolve(AppArtifact appArtifact) throws AppModelResolverException {
        return this.resolveArtifact(appArtifact).getPaths().getSinglePath();
    }

    private AppArtifact resolveArtifact(AppArtifact appArtifact) throws AppModelResolverException {
        Set resolvedArtifacts;
        if (appArtifact.isResolved()) {
            return appArtifact;
        }
        DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
        dep.setExtension(appArtifact.getType());
        dep.setType(appArtifact.getType());
        dep.setName(appArtifact.getArtifactId());
        if (appArtifact.getClassifier() != null) {
            dep.setClassifier(appArtifact.getClassifier());
        }
        DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getVersion(), null);
        gradleDep.addArtifact((DependencyArtifact)dep);
        Configuration detachedConfig = this.project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep});
        ResolvedConfiguration rc = detachedConfig.getResolvedConfiguration();
        try {
            resolvedArtifacts = rc.getResolvedArtifacts();
        }
        catch (ResolveException e) {
            throw new AppModelResolverException("Failed to resolve " + appArtifact, (Throwable)e);
        }
        for (ResolvedArtifact a : resolvedArtifacts) {
            if (!appArtifact.getArtifactId().equals(a.getName()) || !appArtifact.getType().equals(a.getType()) || !(a.getClassifier() == null ? appArtifact.getClassifier() == null : a.getClassifier().equals(appArtifact.getClassifier())) || !appArtifact.getGroupId().equals(a.getModuleVersion().getId().getGroup())) continue;
            if (!appArtifact.getVersion().equals(a.getModuleVersion().getId().getVersion())) {
                appArtifact = new AppArtifact(appArtifact.getGroupId(), appArtifact.getArtifactId(), appArtifact.getClassifier(), appArtifact.getType(), a.getModuleVersion().getId().getVersion());
            }
            appArtifact.setPath(a.getFile().toPath());
            break;
        }
        if (!appArtifact.isResolved()) {
            throw new AppModelResolverException("Failed to resolve " + appArtifact);
        }
        return appArtifact;
    }

    public List<AppDependency> resolveUserDependencies(AppArtifact appArtifact, List<AppDependency> directDeps) {
        return Collections.emptyList();
    }

    public AppModel resolveModel(AppArtifact appArtifact) throws AppModelResolverException {
        if (this.appModel != null) {
            if (this.appModel.getAppArtifact().equals((Object)appArtifact)) {
                return this.appModel;
            }
            throw new AppModelResolverException("Requested artifact : " + appArtifact + ", does not match loaded model " + this.appModel.getAppArtifact());
        }
        this.appModel = QuarkusModelHelper.convert((QuarkusModel)this.model, (AppArtifact)appArtifact);
        return this.appModel;
    }

    public AppModel resolveModel(AppArtifact root, List<AppDependency> deps) throws AppModelResolverException {
        throw new UnsupportedOperationException();
    }

    public AppModel resolveManagedModel(AppArtifact appArtifact, List<AppDependency> directDeps, AppArtifact managingProject, Set<AppArtifactKey> localProjects) throws AppModelResolverException {
        return this.resolveModel(appArtifact);
    }
}

