/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.GradleGroovyProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleKotlinProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleProjectBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.platform.descriptor.CombinedQuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.resolver.json.QuarkusJsonPlatformDescriptorResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.tasks.Internal;

public abstract class QuarkusPlatformTask
extends QuarkusTask {
    QuarkusPlatformTask(String description) {
        super(description);
    }

    protected QuarkusPlatformDescriptor platformDescriptor() {
        List<Dependency> boms = this.boms();
        if (boms.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        QuarkusJsonPlatformDescriptorResolver platformResolver = QuarkusJsonPlatformDescriptorResolver.newInstance().setArtifactResolver(this.extension().getAppModelResolver()).setMessageWriter((MessageWriter)new GradleMessageWriter(this.getProject().getLogger()));
        QuarkusPlatformDescriptor platform = this.resolvePlatformDescriptor(platformResolver, this.getProject(), boms);
        if (platform != null) {
            return platform;
        }
        List<QuarkusPlatformDescriptor> platforms = this.resolveLegacyPlatforms(platformResolver, boms);
        if (platforms.isEmpty()) {
            throw new GradleException("Failed to determine the Quarkus platform for the project");
        }
        if (platforms.size() == 1) {
            return platforms.get(0);
        }
        CombinedQuarkusPlatformDescriptor.Builder builder = CombinedQuarkusPlatformDescriptor.builder();
        for (QuarkusPlatformDescriptor descriptor : platforms) {
            builder.addPlatform(descriptor);
        }
        return builder.build();
    }

    private List<Dependency> boms() {
        Configuration impl = this.getProject().getConfigurations().getByName("implementation");
        ArrayList<Dependency> boms = new ArrayList<Dependency>();
        impl.getIncoming().getDependencies().forEach(d -> {
            if (!(d instanceof ModuleDependency)) {
                return;
            }
            ModuleDependency module = (ModuleDependency)d;
            Category category = (Category)module.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
            if (category != null && ("enforced-platform".equals(category.getName()) || "platform".equals(category.getName()))) {
                boms.add((Dependency)d);
            }
        });
        return boms;
    }

    private List<QuarkusPlatformDescriptor> resolveLegacyPlatforms(QuarkusJsonPlatformDescriptorResolver platformResolver, List<Dependency> boms) {
        ArrayList<QuarkusPlatformDescriptor> platforms = new ArrayList<QuarkusPlatformDescriptor>(2);
        boms.forEach(bom -> {
            try {
                platforms.add(platformResolver.resolveFromBom(bom.getGroup(), bom.getName(), bom.getVersion()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return platforms;
    }

    private QuarkusPlatformDescriptor resolvePlatformDescriptor(QuarkusJsonPlatformDescriptorResolver descriptorResolver, Project project, List<Dependency> bomDeps) {
        Configuration boms = project.getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        HashSet processedKeys = new HashSet(1);
        ArrayList descriptorDeps = new ArrayList(2);
        boms.getResolutionStrategy().eachDependency(d -> {
            if (!d.getTarget().getName().endsWith("-quarkus-platform-descriptor") || !processedKeys.add(new AppArtifactKey(d.getTarget().getGroup(), d.getTarget().getName()))) {
                return;
            }
            DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
            dep.setExtension("json");
            dep.setType("json");
            dep.setClassifier(d.getTarget().getVersion());
            dep.setName(d.getTarget().getName());
            DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(d.getTarget().getGroup(), d.getTarget().getName(), d.getTarget().getVersion(), null);
            gradleDep.addArtifact((DependencyArtifact)dep);
            try {
                for (ResolvedArtifact a : project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep}).getResolvedConfiguration().getResolvedArtifacts()) {
                    if (!a.getName().equals(d.getTarget().getName())) continue;
                    descriptorDeps.add(a);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        boms.getResolvedConfiguration();
        if (descriptorDeps.isEmpty()) {
            return null;
        }
        if (descriptorDeps.size() == 1) {
            return descriptorResolver.resolveFromJson(((ResolvedArtifact)descriptorDeps.get(0)).getFile().toPath());
        }
        int i = 0;
        ResolvedArtifact platformArtifact = (ResolvedArtifact)descriptorDeps.get(0);
        String quarkusBomPlatformArtifactId = "quarkus-bom--quarkus-platform-descriptor";
        ResolvedArtifact quarkusBomPlatformArtifact = null;
        if ("quarkus-bom--quarkus-platform-descriptor".equals(platformArtifact.getName())) {
            quarkusBomPlatformArtifact = platformArtifact;
        }
        CombinedQuarkusPlatformDescriptor.Builder builder = CombinedQuarkusPlatformDescriptor.builder();
        while (++i < descriptorDeps.size()) {
            platformArtifact = (ResolvedArtifact)descriptorDeps.get(i);
            QuarkusPlatformDescriptor descriptor = descriptorResolver.resolveFromJson(platformArtifact.getFile().toPath());
            if (quarkusBomPlatformArtifact != null) {
                if (!quarkusBomPlatformArtifact.getModuleVersion().getId().getVersion().equals(descriptor.getQuarkusVersion())) {
                    builder.addPlatform(descriptorResolver.resolveFromJson(quarkusBomPlatformArtifact.getFile().toPath()));
                }
                quarkusBomPlatformArtifact = null;
            }
            builder.addPlatform(descriptorResolver.resolveFromJson(platformArtifact.getFile().toPath()));
        }
        return builder.build();
    }

    @Internal
    protected QuarkusProject getQuarkusProject() {
        GradleProjectBuildFile buildFile;
        Path rootProjectPath;
        QuarkusPlatformDescriptor platformDescriptor = this.platformDescriptor();
        Path projectDirPath = this.getProject().getProjectDir().toPath();
        Path path = rootProjectPath = this.getProject().getParent() != null ? this.getProject().getRootProject().getProjectDir().toPath() : projectDirPath;
        if (Files.exists(rootProjectPath.resolve("settings.gradle.kts"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle.kts"), new LinkOption[0])) {
            buildFile = new GradleKotlinProjectBuildFile(this.getProject(), platformDescriptor);
        } else if (Files.exists(rootProjectPath.resolve("settings.gradle"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle"), new LinkOption[0])) {
            buildFile = new GradleGroovyProjectBuildFile(this.getProject(), platformDescriptor);
        } else {
            throw new GradleException("Mixed DSL is not supported. Both build and settings file need to use either Kotlin or Groovy DSL");
        }
        return QuarkusProject.of((Path)this.getProject().getProjectDir().toPath(), (QuarkusPlatformDescriptor)platformDescriptor, (ExtensionManager)buildFile);
    }

    protected static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GradleException("Malformed URL:" + url, (Throwable)e);
        }
    }
}

