/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import io.quarkus.registry.DefaultExtensionRegistry;
import io.quarkus.registry.ExtensionRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusAddExtension
extends QuarkusPlatformTask {
    private List<String> extensionsToAdd;
    private List<String> registries;

    public QuarkusAddExtension() {
        super("Adds Quarkus extensions specified by the user to the project.");
    }

    @Option(option="extensions", description="Configures the extensions to be added.")
    public void setExtensionsToAdd(List<String> extensionsToAdd) {
        this.extensionsToAdd = extensionsToAdd;
    }

    @Input
    public List<String> getExtensionsToAdd() {
        return this.extensionsToAdd;
    }

    @Optional
    @Input
    public List<String> getRegistries() {
        return this.registries;
    }

    @Option(description="The extension registry URLs to be used", option="registry")
    public void setRegistries(List<String> registry) {
        this.registries = registry;
    }

    @TaskAction
    public void addExtension() {
        Set extensionsSet = this.getExtensionsToAdd().stream().flatMap(ext -> Arrays.stream(ext.split(","))).map(String::trim).collect(Collectors.toSet());
        try {
            AddExtensions addExtensions = new AddExtensions(this.getQuarkusProject()).extensions(extensionsSet);
            if (this.registries != null && !this.registries.isEmpty()) {
                List urls = this.registries.stream().map(QuarkusPlatformTask::toURL).collect(Collectors.toList());
                addExtensions.extensionRegistry((ExtensionRegistry)DefaultExtensionRegistry.fromURLs(urls));
            }
            addExtensions.execute();
        }
        catch (Exception e) {
            throw new GradleException("Failed to add extensions " + this.getExtensionsToAdd(), (Throwable)e);
        }
    }
}

