/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.logging.Logger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.wildfly.common.Assert;

public class GradleLogger
implements LoggerProvider {
    static final Object[] NO_PARAMS = new Object[0];
    public static volatile Supplier<Logger> logSupplier;

    public org.jboss.logging.Logger getLogger(final String name) {
        return new org.jboss.logging.Logger(name){

            protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
                Supplier<Logger> logSupplier = GradleLogger.logSupplier;
                if (logSupplier != null) {
                    String text;
                    Logger log = logSupplier.get();
                    if (parameters == null || parameters.length == 0) {
                        text = String.valueOf(message);
                    } else {
                        try {
                            text = MessageFormat.format(String.valueOf(message), parameters);
                        }
                        catch (Exception e) {
                            text = GradleLogger.this.invalidFormat(String.valueOf(message), parameters);
                        }
                    }
                    this.doActualLog(log, level, text, thrown);
                }
            }

            protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
                Supplier<Logger> logSupplier = GradleLogger.logSupplier;
                if (logSupplier != null) {
                    String text;
                    Logger log = logSupplier.get();
                    if (parameters == null) {
                        try {
                            text = String.format(format, new Object[0]);
                        }
                        catch (Exception e) {
                            text = GradleLogger.this.invalidFormat(format, NO_PARAMS);
                        }
                    } else {
                        try {
                            text = String.format(format, parameters);
                        }
                        catch (Exception e) {
                            text = GradleLogger.this.invalidFormat(format, parameters);
                        }
                    }
                    this.doActualLog(log, level, text, thrown);
                }
            }

            public boolean isEnabled(Logger.Level level) {
                Supplier<Logger> logSupplier = GradleLogger.logSupplier;
                if (logSupplier == null) {
                    return false;
                }
                Logger log = logSupplier.get();
                switch (level) {
                    case FATAL: 
                    case ERROR: {
                        return log.isErrorEnabled();
                    }
                    case WARN: {
                        return log.isWarnEnabled();
                    }
                    case INFO: {
                        return log.isInfoEnabled();
                    }
                }
                return log.isDebugEnabled();
            }

            void doActualLog(Logger log, Logger.Level level, String message, Throwable thrown) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("[").append(name).append("]").append(" ").append(message);
                if (thrown != null) {
                    switch (level) {
                        case FATAL: 
                        case ERROR: {
                            log.error(buffer.toString(), thrown);
                            break;
                        }
                        case WARN: {
                            log.warn(buffer.toString(), thrown);
                            break;
                        }
                        case INFO: {
                            log.info(buffer.toString(), thrown);
                            break;
                        }
                        default: {
                            log.debug(buffer.toString(), thrown);
                            break;
                        }
                    }
                } else {
                    switch (level) {
                        case FATAL: 
                        case ERROR: {
                            log.error(buffer.toString());
                            break;
                        }
                        case WARN: {
                            log.warn(buffer.toString());
                            break;
                        }
                        case INFO: {
                            log.info(buffer.toString());
                            break;
                        }
                        default: {
                            log.debug(buffer.toString());
                        }
                    }
                }
            }
        };
    }

    String invalidFormat(String format, Object[] parameters) {
        StringBuilder b = new StringBuilder("** invalid format '" + format + "'");
        if (parameters != null && parameters.length > 0) {
            b.append(" [").append(parameters[0]);
            for (int i = 1; i < parameters.length; ++i) {
                b.append(',').append(parameters[i]);
            }
            b.append("]");
        }
        return b.toString();
    }

    public void clearMdc() {
    }

    public Object putMdc(String key, Object value) {
        return null;
    }

    public Object getMdc(String key) {
        return null;
    }

    public void removeMdc(String key) {
    }

    public Map<String, Object> getMdcMap() {
        return Collections.emptyMap();
    }

    public void clearNdc() {
    }

    public String getNdc() {
        return "";
    }

    public int getNdcDepth() {
        return 0;
    }

    public String popNdc() {
        return "";
    }

    public String peekNdc() {
        return "";
    }

    public void pushNdc(String message) {
        throw Assert.unsupported();
    }

    public void setNdcMaxDepth(int maxDepth) {
    }
}

