/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.model.ModelParameter;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.resolver.model.impl.ModelParameterImpl;
import io.quarkus.gradle.AppModelGradleResolver;
import io.quarkus.gradle.builder.QuarkusModelBuilder;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;

public class QuarkusPluginExtension {
    private final Project project;
    private File outputDirectory;
    private String finalName;
    private File sourceDir;
    private File workingDir;
    private File outputConfigDirectory;

    public QuarkusPluginExtension(Project project) {
        this.project = project;
    }

    void beforeTest(Test task) {
        try {
            Map props = task.getSystemProperties();
            AppModel appModel = this.getAppModelResolver(LaunchMode.TEST).resolveModel(this.getAppArtifact());
            Path serializedModel = QuarkusGradleUtils.serializeAppModel(appModel, (Task)task);
            props.put("quarkus-internal.serialized-app-model.path", serializedModel.toString());
            StringJoiner outputSourcesDir = new StringJoiner(",");
            for (File outputSourceDir : this.outputSourcesDir()) {
                outputSourcesDir.add(outputSourceDir.getAbsolutePath());
            }
            props.put("OUTPUT_SOURCES_DIR", outputSourcesDir.toString());
            String fileList = this.getSourceSets().stream().filter(sourceSet -> Objects.equals(task.getTestClassesDirs().getAsPath(), sourceSet.getOutput().getClassesDirs().getAsPath())).flatMap(sourceSet -> sourceSet.getOutput().getClassesDirs().getFiles().stream()).filter(File::exists).distinct().map(testSrcDir -> String.format("%s:%s", this.project.relativePath(testSrcDir), this.project.relativePath((Object)this.outputDirectory()))).collect(Collectors.joining(","));
            task.environment("TEST_TO_MAIN_MAPPINGS", (Object)fileList);
            String nativeRunner = task.getProject().getBuildDir().toPath().resolve(this.finalName() + "-runner").toAbsolutePath().toString();
            props.put("native.image.path", nativeRunner);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve deployment classpath", e);
        }
    }

    public Path appJarOrClasses() {
        SourceSet mainSourceSet;
        String classesPath;
        Convention convention;
        JavaPluginConvention javaConvention;
        File f;
        Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
        if (jarTask == null) {
            throw new RuntimeException("Failed to locate task 'jar' in the project.");
        }
        Provider jarProvider = jarTask.getArchiveFile();
        Path classesDir = null;
        if (jarProvider.isPresent() && (f = ((RegularFile)jarProvider.get()).getAsFile()).exists()) {
            classesDir = f.toPath();
        }
        if (classesDir == null && (javaConvention = (JavaPluginConvention)(convention = this.project.getConvention()).findPlugin(JavaPluginConvention.class)) != null && (classesPath = QuarkusGradleUtils.getClassesDir(mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main"), jarTask.getTemporaryDir())) != null) {
            classesDir = Paths.get(classesPath, new String[0]);
        }
        if (classesDir == null) {
            throw new RuntimeException("Failed to locate project's classes directory");
        }
        return classesDir;
    }

    public File outputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getLastFile(((SourceSet)this.getSourceSets().getByName("main")).getOutput().getClassesDirs());
        }
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
    }

    public File outputConfigDirectory() {
        if (this.outputConfigDirectory == null) {
            this.outputConfigDirectory = ((SourceSet)this.getSourceSets().getByName("main")).getOutput().getResourcesDir();
        }
        return this.outputConfigDirectory;
    }

    public void setOutputConfigDirectory(String outputConfigDirectory) {
        this.outputConfigDirectory = new File(outputConfigDirectory);
    }

    public File sourceDir() {
        if (this.sourceDir == null) {
            this.sourceDir = this.getLastFile(((SourceSet)this.getSourceSets().getByName("main")).getAllJava().getSourceDirectories());
        }
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = new File(sourceDir);
    }

    public File workingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.outputDirectory();
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = new File(workingDir);
    }

    public String finalName() {
        if (this.finalName == null || this.finalName.length() == 0) {
            this.finalName = String.format("%s-%s", this.project.getName(), this.project.getVersion());
        }
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public Set<File> resourcesDir() {
        return ((SourceSet)this.getSourceSets().getByName("main")).getResources().getSrcDirs();
    }

    public Set<File> outputSourcesDir() {
        return ((SourceSet)this.getSourceSets().getByName("main")).getOutput().getClassesDirs().getFiles();
    }

    public AppArtifact getAppArtifact() {
        return new AppArtifact(this.project.getGroup().toString(), this.project.getName(), this.project.getVersion().toString());
    }

    public AppModelResolver getAppModelResolver() {
        return this.getAppModelResolver(LaunchMode.NORMAL);
    }

    public AppModelResolver getAppModelResolver(LaunchMode mode) {
        return new AppModelGradleResolver(this.project, this.getQuarkusModel(mode));
    }

    public QuarkusModel getQuarkusModel() {
        return this.getQuarkusModel(LaunchMode.NORMAL);
    }

    public QuarkusModel getQuarkusModel(LaunchMode mode) {
        return this.create(this.project, mode);
    }

    private QuarkusModel create(Project project, LaunchMode mode) {
        QuarkusModelBuilder builder = new QuarkusModelBuilder();
        ModelParameterImpl params = new ModelParameterImpl();
        params.setMode(mode.toString());
        return (QuarkusModel)builder.buildAll(QuarkusModel.class.getName(), (ModelParameter)params, project);
    }

    private File getLastFile(FileCollection fileCollection) {
        File result = null;
        for (File f : fileCollection) {
            if (result != null && !f.exists()) continue;
            result = f;
        }
        return result;
    }

    private SourceSetContainer getSourceSets() {
        return ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
    }
}

