/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.deployment.CodeGenerator;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class QuarkusGenerateCode
extends QuarkusTask {
    public static final String QUARKUS_GENERATED_SOURCES = "quarkus-generated-sources";
    public static final String QUARKUS_TEST_GENERATED_SOURCES = "quarkus-test-generated-sources";
    public static final String[] CODE_GENERATION_PROVIDER = new String[]{"grpc"};
    public static final String INIT_AND_RUN = "initAndRun";
    private Set<Path> sourcesDirectories;
    private Consumer<Path> sourceRegistrar;
    private boolean test = false;

    public QuarkusGenerateCode() {
        super("Performs Quarkus pre-build preparations, such as sources generation");
    }

    @TaskAction
    public void prepareQuarkus() {
        this.getLogger().lifecycle("preparing quarkus application");
        AppArtifact appArtifact = this.extension().getAppArtifact();
        appArtifact.setPaths(QuarkusGradleUtils.getOutputPaths(this.getProject()));
        AppModelResolver modelResolver = this.extension().getAppModelResolver();
        Properties realProperties = this.getBuildSystemProperties(appArtifact);
        Path buildDir = this.getProject().getBuildDir().toPath();
        try (CuratedApplication appCreationContext = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setAppModelResolver(modelResolver).setTargetDirectory(buildDir).setBaseName(this.extension().finalName()).setBuildSystemProperties(realProperties).setAppArtifact(appArtifact).setLocalProjectDiscovery(false).setIsolateDeployment(true).build().bootstrap();){
            Convention convention = this.getProject().getConvention();
            JavaPluginConvention javaConvention = (JavaPluginConvention)convention.findPlugin(JavaPluginConvention.class);
            if (javaConvention != null) {
                String generateSourcesDir = this.test ? QUARKUS_TEST_GENERATED_SOURCES : QUARKUS_GENERATED_SOURCES;
                SourceSet generatedSources = (SourceSet)javaConvention.getSourceSets().findByName(generateSourcesDir);
                ArrayList paths = new ArrayList();
                generatedSources.getOutput().filter(f -> f.getName().equals(generateSourcesDir)).forEach(f -> paths.add(f.toPath()));
                if (paths.isEmpty()) {
                    throw new GradleException("Failed to create quarkus-generated-sources");
                }
                this.getLogger().debug("Will trigger preparing sources for source directory: {} buildDir: {}", this.sourcesDirectories, (Object)this.getProject().getBuildDir().getAbsolutePath());
                QuarkusClassLoader deploymentClassLoader = appCreationContext.createDeploymentClassLoader();
                Class codeGenerator = deploymentClassLoader.loadClass(CodeGenerator.class.getName());
                Optional<Method> initAndRun = Arrays.stream(codeGenerator.getMethods()).filter(m -> m.getName().equals(INIT_AND_RUN)).findAny();
                if (!initAndRun.isPresent()) {
                    throw new GradleException("Failed to find initAndRun method in " + CodeGenerator.class.getName());
                }
                initAndRun.get().invoke(null, deploymentClassLoader, this.sourcesDirectories, paths.iterator().next(), buildDir, this.sourceRegistrar, appCreationContext.getAppModel(), realProperties);
            }
        }
        catch (BootstrapException | ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new GradleException("Failed to generate sources in the QuarkusPrepare task", e);
        }
    }

    public void setSourcesDirectories(Set<Path> sourcesDirectories) {
        this.sourcesDirectories = sourcesDirectories;
    }

    public void setSourceRegistrar(Consumer<Path> sourceRegistrar) {
        this.sourceRegistrar = sourceRegistrar;
    }

    public void setTest(boolean test) {
        this.test = test;
    }
}

