/*
 * Decompiled with CFR 0.152.
 */
package de.infonautika.postman.task;

import de.infonautika.postman.PostmanExtension;
import de.infonautika.postman.newman.NewmanRunner;
import de.infonautika.postman.settings.NewmanSettings;
import de.infonautika.postman.settings.PreferredSettings;
import de.infonautika.postman.task.util.Supplier;
import java.io.File;
import java.util.Arrays;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.TaskAction;

public class PostmanTask
extends DefaultTask {
    public static final String NAME = "postman";
    private PreferredSettings settings;

    public PostmanTask() {
        this.setGroup("Postman");
        this.setDescription("executes Postman collections");
        this.dependsOn(new Object[]{Arrays.asList("nodeSetup", "installNewman", "deployWrapper")});
        this.buildSettings();
    }

    private void buildSettings() {
        this.settings = new PreferredSettings(new Supplier<NewmanSettings>(){

            @Override
            public NewmanSettings get() {
                return (NewmanSettings)PostmanTask.this.getProject().getExtensions().getByType(PostmanExtension.class);
            }
        });
    }

    @TaskAction
    public void runPostmanCollections() {
        NewmanRunner newmanRunner = new NewmanRunner(this.getProject(), this.settings);
        if (!newmanRunner.runCollections()) {
            throw new GradleException("There were failing tests.");
        }
    }

    public void setCollections(FileTree collections) {
        this.settings.setCollections(collections);
    }

    public void setEnvironment(File environment) {
        this.settings.setEnvironment(environment);
    }

    public void setCliReport(boolean cliReport) {
        this.settings.setCliReport(cliReport);
    }

    public void setXmlReportDir(String xmlReportDir) {
        this.settings.setXmlReportDir(xmlReportDir);
    }

    public void setStopOnError(boolean stopOnError) {
        this.settings.setStopOnError(stopOnError);
    }

    public void setNoColor(boolean noColor) {
        this.settings.setNoColor(noColor);
    }

    public void setDisableUnicode(boolean disableUnicode) {
        this.settings.setDisableUnicode(disableUnicode);
    }

    public void setHtmlReportDir(String htmlReportDir) {
        this.settings.setHtmlReportDir(htmlReportDir);
    }

    public void setHtmlTemplate(String htmlTemplate) {
        this.settings.setHtmlTemplate(htmlTemplate);
    }

    public void setJsonReportDir(String jsonReportDir) {
        this.settings.setJsonReportDir(jsonReportDir);
    }
}

