/*
 * Decompiled with CFR 0.152.
 */
package de.infonautika.postman.newman;

import com.moowork.gradle.node.exec.NodeExecRunner;
import de.infonautika.postman.newman.NewmanConfig;
import de.infonautika.postman.newman.NewmanWrapper;
import de.infonautika.postman.settings.PreferredSettings;
import java.io.File;
import java.util.Arrays;
import org.gradle.api.Project;
import org.gradle.process.internal.ExecException;

public class NewmanRunner {
    private final NodeExecRunner nodeExecRunner;
    private Project project;
    private final PreferredSettings settings;

    public NewmanRunner(Project project, PreferredSettings settings) {
        this.project = project;
        this.settings = settings;
        this.nodeExecRunner = new NodeExecRunner(project);
    }

    public boolean runCollections() {
        this.nodeExecRunner.setIgnoreExitValue(!this.settings.getStopOnError());
        if (this.settings.getStopOnError()) {
            return this.runUntilFail();
        }
        return this.runAllCollections();
    }

    private boolean runUntilFail() {
        for (File collection : this.settings.getCollections()) {
            if (this.runSingleCollection(collection)) continue;
            return false;
        }
        return true;
    }

    private boolean runAllCollections() {
        boolean success = true;
        for (File collection : this.settings.getCollections()) {
            success &= this.runSingleCollection(collection);
        }
        return success;
    }

    private boolean runSingleCollection(File collection) {
        this.nodeExecRunner.setArguments(Arrays.asList(this.getWrapperAbsolutePath().toString(), this.getNewmanConfiguration(collection)));
        try {
            return this.nodeExecRunner.execute().getExitValue() == 0;
        }
        catch (ExecException ignored) {
            return false;
        }
    }

    private File getWrapperAbsolutePath() {
        return new NewmanWrapper(this.project).getWrapperAbsolutePath();
    }

    private String getNewmanConfiguration(File collection) {
        NewmanConfig newmanConfig = new NewmanConfig(this.project, this.settings);
        return newmanConfig.toJsonFor(collection).replaceAll("\"", "<>");
    }
}

