/*
 * Decompiled with CFR 0.152.
 */
package de.infonautika.postman.newman;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.infonautika.postman.settings.NewmanSettings;
import de.infonautika.postman.task.util.Json;
import java.io.File;
import org.gradle.api.Project;

class NewmanConfig {
    private Project project;
    private NewmanSettings settings;

    NewmanConfig(Project project, NewmanSettings settings) {
        this.project = project;
        this.settings = settings;
    }

    String toJsonFor(File collection) {
        return new JsonBuilder(collection).build();
    }

    private class JsonBuilder {
        private JsonObject params = Json.object();
        private File collection;

        JsonBuilder(File collection) {
            this.collection = collection;
        }

        private String build() {
            this.buildParameters();
            return this.params.toString();
        }

        private void buildParameters() {
            this.addCollection();
            this.addEnvironment();
            this.addReporters();
            this.addBail();
            this.addNoColor();
            this.addDisableUnicode();
        }

        private void addCollection() {
            this.params.add("collection", (JsonElement)Json.primitive(this.collection.toString()));
        }

        private void addReporters() {
            JsonArray reporters = Json.array();
            JsonObject reporter = Json.object();
            this.addCli(reporters);
            this.addJunit(reporters, reporter);
            this.addJson(reporters, reporter);
            this.addHtml(reporters, reporter);
            if (!Json.empty(reporters)) {
                this.params.add("reporters", (JsonElement)reporters);
            }
            if (!Json.empty(reporter)) {
                this.params.add("reporter", (JsonElement)reporter);
            }
        }

        private void addJunit(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getXmlReportDir() != null) {
                reporters.add((JsonElement)Json.primitive("junit"));
                reporter.add("junit", (JsonElement)Json.object("export", this.projectFile(NewmanConfig.this.settings.getXmlReportDir(), "TEST-postman-" + this.collection.getName() + ".xml")));
            }
        }

        private void addJson(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getJsonReportDir() != null) {
                reporters.add("json");
                reporter.add("json", (JsonElement)Json.object("export", this.projectFile(NewmanConfig.this.settings.getJsonReportDir(), this.endsWithJson("TEST-postman-" + this.collection.getName()))));
            }
        }

        private void addHtml(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getHtmlReportDir() != null) {
                reporters.add("html");
                JsonObject htmlOptions = Json.object();
                reporter.add("html", (JsonElement)htmlOptions);
                htmlOptions.addProperty("export", this.projectFile(NewmanConfig.this.settings.getHtmlReportDir(), "TEST-postman-" + this.collection.getName() + ".html"));
                if (NewmanConfig.this.settings.getHtmlTemplate() != null) {
                    htmlOptions.addProperty("template", this.projectFile(NewmanConfig.this.settings.getHtmlTemplate()));
                }
            }
        }

        private String projectFile(String ... parts) {
            return this.compose(NewmanConfig.this.project.getProjectDir(), parts).toString();
        }

        private File compose(File file, String[] parts) {
            for (String part : parts) {
                file = new File(file, part);
            }
            return file;
        }

        private void addCli(JsonArray reporters) {
            if (NewmanConfig.this.settings.getCliReport()) {
                reporters.add((JsonElement)Json.primitive("cli"));
            }
        }

        private void addEnvironment() {
            if (NewmanConfig.this.settings.getEnvironment() != null) {
                this.params.add("environment", (JsonElement)new JsonPrimitive(NewmanConfig.this.settings.getEnvironment().toString()));
            }
        }

        private void addBail() {
            this.params.add("bail", (JsonElement)Json.primitive(NewmanConfig.this.settings.getStopOnError()));
        }

        private void addNoColor() {
            this.params.add("noColor", (JsonElement)Json.primitive(NewmanConfig.this.settings.getNoColor()));
        }

        private void addDisableUnicode() {
            this.params.add("disableUnicode", (JsonElement)Json.primitive(NewmanConfig.this.settings.getDisableUnicode()));
        }

        private String endsWithJson(String fileName) {
            if (fileName.endsWith(".json")) {
                return fileName;
            }
            return fileName + ".json";
        }
    }
}

