/*
 * Decompiled with CFR 0.152.
 */
package de.inetsoftware.jwebassembly.gradle;

import de.inetsoftware.jwebassembly.gradle.OutputFormat;
import de.inetsoftware.jwebassembly.gradle.WasmCompiler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class WasmTask
extends AbstractArchiveTask {
    private String compilerVersion = "+";
    private OutputFormat format;
    private final Map<String, String> props = new HashMap<String, String>();
    private FileCollection classpath;

    public WasmTask() {
        this.setFormat(OutputFormat.Binary);
    }

    @Input
    public String getCompilerVersion() {
        return this.compilerVersion;
    }

    public void setCompilerVersion(String version) {
        this.compilerVersion = version;
    }

    @Input
    public OutputFormat getFormat() {
        return this.format;
    }

    public void setFormat(OutputFormat format) {
        this.format = format;
        if (format == OutputFormat.Binary) {
            this.setExtension("wasm");
        } else {
            this.setExtension("wat");
        }
    }

    @Input
    public boolean isDebugNames() {
        return Boolean.parseBoolean(this.getProperty("DebugNames"));
    }

    public void setDebugNames(boolean debugNames) {
        this.setProperty("DebugNames", Boolean.toString(debugNames));
    }

    @Input
    public String getSourceMapBase() {
        String str = this.getProperty("SourceMapBase");
        return str == null ? "" : str;
    }

    public void setSourceMapBase(String sourceMapBase) {
        this.setProperty("SourceMapBase", sourceMapBase);
    }

    @Input
    public Map<String, String> getProperties() {
        return this.props;
    }

    public String getProperty(String key) {
        return this.props.get(key);
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.props.put(key, value);
        } else {
            this.props.remove(key);
        }
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection configuration) {
        this.classpath = configuration;
    }

    protected CopyAction createCopyAction() {
        final WasmCompiler compiler = new WasmCompiler(this);
        return new CopyAction(){

            public WorkResult execute(CopyActionProcessingStream stream) {
                stream.process(new CopyActionProcessingStreamAction(){

                    public void processFile(FileCopyDetailsInternal details) {
                        if (!details.isDirectory()) {
                            compiler.addFile(details.getFile());
                        }
                    }
                });
                for (File file : WasmTask.this.getClasspath().getFiles()) {
                    String name = file.getName().toLowerCase();
                    if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                    compiler.addLibrary(file);
                }
                compiler.compile();
                return WorkResults.didWork((boolean)true);
            }
        };
    }
}

