/*
 * Decompiled with CFR 0.152.
 */
package de.inetsoftware.jwebassembly.gradle;

import de.inetsoftware.jwebassembly.gradle.OutputFormat;
import de.inetsoftware.jwebassembly.gradle.WasmCompiler;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class WasmTask
extends AbstractArchiveTask {
    private boolean debugNames;
    private String compilerVersion = "+";
    private OutputFormat format;

    public WasmTask() {
        this.setFormat(OutputFormat.Binary);
    }

    @Input
    public String getCompilerVersion() {
        return this.compilerVersion;
    }

    public void setCompilerVersion(String version) {
        this.compilerVersion = version;
    }

    @Input
    public OutputFormat getFormat() {
        return this.format;
    }

    public void setFormat(OutputFormat format) {
        this.format = format;
        if (format == OutputFormat.Binary) {
            this.setExtension("wasm");
        } else {
            this.setExtension("wat");
        }
    }

    @Input
    public boolean isDebugNames() {
        return this.debugNames;
    }

    public void setDebugNames(boolean debugNames) {
        this.debugNames = debugNames;
    }

    protected CopyAction createCopyAction() {
        final WasmCompiler compiler = new WasmCompiler(this);
        return new CopyAction(){

            public WorkResult execute(CopyActionProcessingStream stream) {
                stream.process(new CopyActionProcessingStreamAction(){

                    public void processFile(FileCopyDetailsInternal details) {
                        if (!details.isDirectory()) {
                            compiler.addFile(details.getFile());
                        }
                    }
                });
                compiler.compile();
                return WorkResults.didWork((boolean)true);
            }
        };
    }
}

