/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.AppBundlerTask;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class Runtime
extends FileSet {
    public Runtime(File jreDir) {
        this.setDir(jreDir);
    }

    public File getDir() {
        File dir = super.getDir();
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir;
        }
    }

    public void appendIncludes(String[] includes) {
        this.patchIncludeExcludes(includes);
        super.appendIncludes(includes);
    }

    public void appendExcludes(String[] excludes) {
        this.patchIncludeExcludes(excludes);
        super.appendIncludes(excludes);
    }

    private void patchIncludeExcludes(String[] includExclude) {
        boolean isJDK = new File(this.getDir(), "jre").isDirectory();
        if (isJDK) {
            for (int i = 0; i < includExclude.length; ++i) {
                if (includExclude[i].startsWith("jre/")) continue;
                includExclude[i] = "jre/" + includExclude[i];
            }
        }
    }

    void copyTo(File targetDir, Project project) throws IOException {
        File runtimeHomeDirectory = this.getDir();
        File runtimeContentsDirectory = runtimeHomeDirectory.getParentFile();
        File runtimeDirectory = runtimeContentsDirectory.getParentFile();
        File pluginDirectory = new File(targetDir, this.normalizeJVMName(runtimeDirectory));
        pluginDirectory.mkdir();
        File pluginContentsDirectory = new File(pluginDirectory, runtimeContentsDirectory.getName());
        pluginContentsDirectory.mkdir();
        File runtimeMacOSDirectory = new File(runtimeContentsDirectory, "MacOS");
        AppBundlerTask.copy(runtimeMacOSDirectory, new File(pluginContentsDirectory, runtimeMacOSDirectory.getName()));
        File runtimeInfoPlistFile = new File(runtimeContentsDirectory, "Info.plist");
        AppBundlerTask.copy(runtimeInfoPlistFile, new File(pluginContentsDirectory, runtimeInfoPlistFile.getName()));
        File pluginHomeDirectory = new File(pluginContentsDirectory, runtimeHomeDirectory.getName());
        DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
        String[] includedFiles = directoryScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            String includedFile = includedFiles[i];
            File source = new File(runtimeHomeDirectory, includedFile);
            File destination = new File(pluginHomeDirectory, includedFile);
            AppBundlerTask.copy(source, destination);
        }
    }

    public String normalizeJVMName(File jvm) {
        return jvm.getName().contains(".") ? jvm.getName() : jvm.getName() + ".jre";
    }
}

