/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.util;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.AbstractSetupTask;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlFileBuilder<T extends AbstractSetupTask> {
    public final T task;
    public final SetupBuilder setup;
    public final File xmlFile;
    public final File buildDir;
    public final Document doc;

    public XmlFileBuilder(T task, SetupBuilder setup, File xmlFile, File buildDir, URL template) throws Exception {
        this.task = task;
        this.setup = setup;
        this.xmlFile = xmlFile;
        this.buildDir = buildDir;
        xmlFile.getParentFile().mkdirs();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setIgnoringComments(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        this.doc = template != null ? docBuilder.parse(template.toString()) : docBuilder.newDocument();
    }

    public void save() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.xmlFile);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
    }

    public void addAttributeIfNotExists(Element el, String name, String value) {
        if (!el.hasAttribute(name)) {
            el.setAttribute(name, value);
        }
    }

    public void addNodeText(Element el, String text) {
        Document doc = el.getOwnerDocument();
        el.appendChild(doc.createTextNode(text));
    }

    public Element getOrCreateChild(Node parent, String name) {
        return this.getOrCreateChild(parent, name, true);
    }

    public Element getOrCreateChild(Node parent, String name, boolean append) {
        Node first;
        for (Node child = first = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return this.createChild(parent, name, append);
    }

    public Element getOrCreateChild(Node parent, String name, String textNodeValue, boolean append) {
        Node first;
        Node child;
        for (child = first = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!name.equals(child.getNodeName()) || child.getFirstChild().getNodeType() != 3 || !textNodeValue.equals(child.getFirstChild().getTextContent())) continue;
            return (Element)child;
        }
        child = this.createChild(parent, name, append);
        this.addNodeText((Element)child, textNodeValue);
        return child;
    }

    public Element createChild(Node parent, String name, boolean append) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element child = doc.createElement(name);
        Node first = parent.getFirstChild();
        if (append || first == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, first);
        }
        return child;
    }

    public Element getOrCreateChildById(Node parent, String name, String id) {
        return this.getOrCreateChildByKeyValue(parent, name, "Id", id, true);
    }

    public Element getOrCreateChildById(Node parent, String name, String id, boolean append) {
        return this.getOrCreateChildByKeyValue(parent, name, "Id", id, append);
    }

    public Element getOrCreateChildByKeyValue(Node parent, String name, String key, String value) {
        return this.getOrCreateChildByKeyValue(parent, name, key, value, true);
    }

    public Element getOrCreateChildByKeyValue(Node parent, String name, String key, String value, boolean append) {
        Node first;
        for (Node child = first = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!name.equals(child.getNodeName()) || !Objects.equals(value, ((Element)child).getAttribute(key)) && (value != null || ((Element)child).hasAttribute(key))) continue;
            return (Element)child;
        }
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElement(name);
        if (value != null) {
            child.setAttribute(key, value);
        }
        if (append || first == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, first);
        }
        return child;
    }
}

