/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.util;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;

public abstract class GradleUtils {
    public static boolean isTaskExecute(Task task, Project project) {
        String name = task.getName();
        List startTasks = project.getGradle().getStartParameter().getTaskNames();
        TaskContainer tasks = project.getTasks();
        for (String startTaskName : startTasks) {
            if (Objects.equals(name, startTaskName)) {
                return true;
            }
            try {
                Task startTask = tasks.getByName(startTaskName);
                if (!GradleUtils.isTaskExecute(task, name, startTask, tasks)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    private static boolean isTaskExecute(Task task, String name, Task startTask, TaskContainer tasks) {
        if (startTask == null) {
            return false;
        }
        Set dependsOn = startTask.getDependsOn();
        for (Object depObject : dependsOn) {
            if (Objects.equals(name, depObject)) {
                return true;
            }
            if (Objects.equals(task, depObject)) {
                return true;
            }
            Task depTask = null;
            if (depObject instanceof String) {
                depTask = tasks.getByName((String)depObject);
            } else if (depObject instanceof Task) {
                depTask = (Task)depObject;
            }
            if (!GradleUtils.isTaskExecute(task, name, depTask, tasks)) continue;
            return true;
        }
        return false;
    }
}

